/**
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 *
 */
package org.exoplatform.gwtframework.ui.client.smartgwt.dialogs;

/**
 * Created by The eXo Platform SAS .
 * 
 * @author <a href="mailto:gavrikvetal@gmail.com">Vitaliy Gulyy</a>
 * @version $
 */

public class DialogInfo
{

   public enum Type 
   {

      INFO,

      WARNING,

      ASK,

      ASKVALUE

   }

   private String title;

   private String message;

   private Type type;

   private String defaultValue;

   private Object callback;

   public DialogInfo(String title, String message, Type type)
   {
      this.title = title;
      this.message = message;
      this.type = type;
   }

   public DialogInfo(String title, String message, Type type, Object callback)
   {
      this(title, message, type);
      this.callback = callback;
   }

   public DialogInfo(String title, String message, Type type, String defaultValue, Object callback)
   {
      this(title, message, type);
      this.defaultValue = defaultValue;
      this.callback = callback;
   }

   public String getTitle()
   {
      return title;
   }

   public String getMessage()
   {
      return message;
   }

   public Type getType()
   {
      return type;
   }

   public Object getCallback()
   {
      return callback;
   }

   public String getDefaultValue()
   {
      return defaultValue;
   }

}
