/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.RootDoc;
import com.sun.tools.doclets.Configuration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class ClassTree {
    private List baseclasses = new ArrayList();
    private Map subclasses = new HashMap();
    private List baseinterfaces = new ArrayList();
    private Map subinterfaces = new HashMap();
    private Map implementingclasses = new HashMap();

    private void processClass(ClassDoc classDoc) {
        ClassDoc classDoc2 = classDoc.superclass();
        if (classDoc2 != null) {
            if (!this.add(this.subclasses, classDoc2, classDoc)) {
                return;
            }
            this.processClass(classDoc2);
        } else if (!this.baseclasses.contains(classDoc)) {
            this.baseclasses.add(classDoc);
        }
        ClassDoc[] classDocArray = classDoc.interfaces();
        int n = 0;
        while (n < classDocArray.length) {
            this.add(this.implementingclasses, classDocArray[n], classDoc);
            ++n;
        }
    }

    private void processInterface(ClassDoc classDoc) {
        ClassDoc[] classDocArray = classDoc.interfaces();
        if (classDocArray.length > 0) {
            int n = 0;
            while (n < classDocArray.length) {
                if (!this.add(this.subinterfaces, classDocArray[n], classDoc)) {
                    return;
                }
                this.processInterface(classDocArray[n]);
                ++n;
            }
        } else if (!this.baseinterfaces.contains(classDoc)) {
            this.baseinterfaces.add(classDoc);
        }
    }

    public ClassTree(ClassDoc[] classDocArray, boolean bl) {
        this.buildTree(classDocArray, bl);
    }

    private void buildTree(ClassDoc[] classDocArray, boolean bl) {
        Object object;
        int n = 0;
        while (n < classDocArray.length) {
            if (!bl || classDocArray[n].tags("deprecated").length <= 0) {
                if (classDocArray[n].isClass()) {
                    this.processClass(classDocArray[n]);
                } else {
                    this.processInterface(classDocArray[n]);
                    object = (List)this.implementingclasses.get(classDocArray[n]);
                    if (object != null) {
                        Collections.sort(object);
                    }
                }
            }
            ++n;
        }
        Collections.sort(this.baseinterfaces);
        object = this.subinterfaces.values().iterator();
        while (object.hasNext()) {
            Collections.sort((List)object.next());
        }
        Iterator iterator = this.subclasses.values().iterator();
        while (iterator.hasNext()) {
            Collections.sort((List)iterator.next());
        }
    }

    public ClassTree(RootDoc rootDoc, boolean bl) {
        this.buildTree(rootDoc.classes(), bl);
    }

    public ClassTree(Configuration configuration, boolean bl) {
        configuration.message.notice("doclet.Building_Tree");
        this.buildTree(configuration.root.classes(), bl);
    }

    public List baseclasses() {
        return this.baseclasses;
    }

    public List baseinterfaces() {
        return this.baseinterfaces;
    }

    public List allSubs(ClassDoc classDoc) {
        List list = this.get(classDoc.isInterface() ? this.subinterfaces : this.subclasses, classDoc);
        int n = 0;
        while (n < list.size()) {
            classDoc = (ClassDoc)list.get(n);
            List list2 = this.get(classDoc.isInterface() ? this.subinterfaces : this.subclasses, classDoc);
            int n2 = 0;
            while (n2 < list2.size()) {
                ClassDoc classDoc2 = (ClassDoc)list2.get(n2);
                if (!list.contains(classDoc2)) {
                    list.add(classDoc2);
                }
                ++n2;
            }
            ++n;
        }
        Collections.sort(list);
        return list;
    }

    public List implementingclasses(ClassDoc classDoc) {
        List list = this.get(this.implementingclasses, classDoc);
        List list2 = this.allSubs(classDoc);
        ListIterator listIterator = list2.listIterator();
        while (listIterator.hasNext()) {
            ListIterator listIterator2 = this.implementingclasses((ClassDoc)listIterator.next()).listIterator();
            while (listIterator2.hasNext()) {
                ClassDoc classDoc2 = (ClassDoc)listIterator2.next();
                if (list.contains(classDoc2)) continue;
                list.add(classDoc2);
            }
        }
        return list;
    }

    public List subclasses(ClassDoc classDoc) {
        return this.get(this.subclasses, classDoc);
    }

    public List subinterfaces(ClassDoc classDoc) {
        return this.get(this.subinterfaces, classDoc);
    }

    public List subs(ClassDoc classDoc) {
        return this.get(classDoc.isInterface() ? this.subinterfaces : this.subclasses, classDoc);
    }

    private boolean add(Map map, ClassDoc classDoc, ClassDoc classDoc2) {
        ArrayList<ClassDoc> arrayList = (ArrayList<ClassDoc>)map.get(classDoc);
        if (arrayList == null) {
            arrayList = new ArrayList<ClassDoc>();
            map.put(classDoc, arrayList);
        }
        if (arrayList.contains(classDoc2)) {
            return false;
        }
        arrayList.add(classDoc2);
        return true;
    }

    private List get(Map map, ClassDoc classDoc) {
        List list = (List)map.get(classDoc);
        if (list == null) {
            return new ArrayList();
        }
        return list;
    }
}

