/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber;

import com.echomine.common.ParseException;
import com.echomine.jabber.JabberCode;
import com.echomine.jabber.JabberMessage;
import com.echomine.jabber.JabberMessageParsable;
import com.echomine.jabber.JabberMessageParser;
import com.echomine.jabber.MessageNotSupportedException;
import java.util.HashMap;
import org.jdom.Element;
import org.jdom.Namespace;

public class DefaultMessageParser
implements JabberMessageParser {
    private HashMap msgParsers = new HashMap();
    private HashMap msgClasses = new HashMap();

    public DefaultMessageParser() {
        try {
            this.setParser("presence", JabberCode.XMLNS_PRESENCE, "com.echomine.jabber.JabberPresenceMessage");
            this.setParser("message", JabberCode.XMLNS_CHAT, "com.echomine.jabber.JabberChatMessage");
            this.setParser("iq", JabberCode.XMLNS_IQ, "com.echomine.jabber.JabberIQMessageParser");
            this.setParser("query", JabberCode.XMLNS_IQ_AUTH, "com.echomine.jabber.AuthIQMessage");
            this.setParser("query", JabberCode.XMLNS_IQ_ROSTER, "com.echomine.jabber.RosterIQMessage");
            this.setParser("query", JabberCode.XMLNS_IQ_REGISTER, "com.echomine.jabber.RegisterIQMessage");
            this.setParser("query", JabberCode.XMLNS_IQ_XMLRPC, "com.echomine.jabber.XMLRPCMessage");
            this.setParser("query", JabberCode.XMLNS_IQ_TIME, "com.echomine.jabber.TimeIQMessage");
            this.setParser("query", JabberCode.XMLNS_IQ_VERSION, "com.echomine.jabber.VersionIQMessage");
            this.setParser("query", JabberCode.XMLNS_IQ_LAST, "com.echomine.jabber.LastIQMessage");
            this.setParser("query", JabberCode.XMLNS_IQ_GATEWAY, "com.echomine.jabber.GatewayIQMessage");
            this.setParser("query", JabberCode.XMLNS_IQ_AGENTS, "com.echomine.jabber.AgentsIQMessage");
            this.setParser("service", JabberCode.XMLNS_IQ, "com.echomine.jabber.BrowseIQMessage");
            this.setParser("service", JabberCode.XMLNS_IQ_BROWSE, "com.echomine.jabber.BrowseIQMessage");
            this.setParser("conference", JabberCode.XMLNS_IQ_BROWSE, "com.echomine.jabber.BrowseIQMessage");
            this.setParser("user", JabberCode.XMLNS_IQ_BROWSE, "com.echomine.jabber.BrowseIQMessage");
            this.setParser("application", JabberCode.XMLNS_IQ_BROWSE, "com.echomine.jabber.BrowseIQMessage");
            this.setParser("headline", JabberCode.XMLNS_IQ_BROWSE, "com.echomine.jabber.BrowseIQMessage");
            this.setParser("render", JabberCode.XMLNS_IQ_BROWSE, "com.echomine.jabber.BrowseIQMessage");
            this.setParser("keyword", JabberCode.XMLNS_IQ_BROWSE, "com.echomine.jabber.BrowseIQMessage");
            this.setParser("x", JabberCode.XMLNS_X_DELAY, "com.echomine.jabber.DelayXMessage");
            this.setParser("x", JabberCode.XMLNS_X_ROSTER, "com.echomine.jabber.RosterXMessage");
            this.setParser("x", JabberCode.XMLNS_X_EVENT, "com.echomine.jabber.EventXMessage");
            this.setParser("x", JabberCode.XMLNS_X_EXPIRE, "com.echomine.jabber.ExpireXMessage");
            this.setParser("x", JabberCode.XMLNS_X_PGP_ENCRYPTED, "com.echomine.jabber.PGPEncryptedXMessage");
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
    }

    public void removeParser(String qName, Namespace ns) {
        Object clsName = this.msgParsers.remove(ns.getURI() + ":" + qName);
        this.msgClasses.remove(clsName);
    }

    public void setParser(String qName, Namespace ns, String msgClass) throws ParseException {
        try {
            Class<?> cls = Class.forName(msgClass);
            JabberMessageParsable parser = (JabberMessageParsable)cls.newInstance();
            this.msgClasses.put(msgClass, cls);
            this.msgParsers.put(ns.getURI() + ":" + qName, msgClass);
        }
        catch (ClassNotFoundException ex) {
            throw new ParseException("Parser class not found");
        }
        catch (ClassCastException ex) {
            throw new ParseException("Parser is not of type JabberMessageParsable");
        }
        catch (InstantiationException ex) {
            throw new ParseException("Parser cannot be initialized to check for validity: " + ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            throw new ParseException("Illegal access while checking for validity: " + ex.getMessage());
        }
    }

    public JabberMessage createMessage(String qName, Namespace ns, Element msgTree) throws MessageNotSupportedException {
        String msgClassName = (String)this.msgParsers.get(ns.getURI() + ":" + qName);
        if (msgClassName == null) {
            throw new MessageNotSupportedException("Parser does not exist for the message");
        }
        JabberMessage msg = null;
        Class msgClass = (Class)this.msgClasses.get(msgClassName);
        if (msgClass != null) {
            try {
                JabberMessageParsable parser = (JabberMessageParsable)msgClass.newInstance();
                msg = parser.parse(this, msgTree);
            }
            catch (InstantiationException ex) {
                throw new MessageNotSupportedException("Error while instantiating message");
            }
            catch (IllegalAccessException ex) {
                throw new MessageNotSupportedException("Illegal access to message");
            }
            catch (ParseException ex) {
                throw new MessageNotSupportedException("Message cannot be properly parsed");
            }
        }
        if (msg == null) {
            throw new MessageNotSupportedException("Parser does not exist for the message");
        }
        return msg;
    }
}

