/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.engine;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.TransactionAbortedException;
import org.exolab.castor.jdo.engine.DatabaseRegistry;
import org.exolab.castor.persist.LockEngine;
import org.exolab.castor.persist.TransactionContext;
import org.exolab.castor.util.Messages;

final class TransactionContextImpl
extends TransactionContext {
    private Hashtable _conns = new Hashtable();
    private boolean _globalTx;

    public TransactionContextImpl(Database db, boolean globalTx) {
        super(db);
        this._globalTx = globalTx;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void commitConnections() throws TransactionAbortedException {
        Enumeration enumeration2;
        if (this._globalTx) {
            Enumeration enumeration2 = this._conns.elements();
            while (true) {
                if (!enumeration2.hasMoreElements()) {
                    this._conns.clear();
                    return;
                }
                try {
                    ((Connection)enumeration2.nextElement()).close();
                }
                catch (SQLException except) {
                    // empty catch block
                }
            }
        }
        try {
            Enumeration enumeration2;
            try {
                enumeration2 = this._conns.elements();
                while (enumeration2.hasMoreElements()) {
                    Connection conn = (Connection)enumeration2.nextElement();
                    conn.commit();
                }
            }
            catch (SQLException except) {
                throw new TransactionAbortedException(Messages.format("persist.nested", except), except);
            }
            Object var5_7 = null;
            enumeration2 = this._conns.elements();
            while (true) {
                if (!enumeration2.hasMoreElements()) break;
                try {
                    ((Connection)enumeration2.nextElement()).close();
                }
                catch (SQLException except) {
                    // empty catch block
                }
            }
            this._conns.clear();
            return;
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            enumeration2 = this._conns.elements();
        }
        while (true) {
            if (!enumeration2.hasMoreElements()) {
                this._conns.clear();
                throw throwable;
            }
            try {}
            catch (SQLException except) {
                // empty catch block
                continue;
            }
            ((Connection)enumeration2.nextElement()).close();
            continue;
            break;
        }
    }

    protected void closeConnections() throws TransactionAbortedException {
        SQLException error = null;
        if (!this._globalTx) {
            return;
        }
        Enumeration enumeration = this._conns.elements();
        while (enumeration.hasMoreElements()) {
            Connection conn = (Connection)enumeration.nextElement();
            try {
                conn.close();
            }
            catch (SQLException except) {
                error = except;
            }
        }
        this._conns.clear();
        if (error != null) {
            throw new TransactionAbortedException(Messages.format("persist.nested", error), error);
        }
    }

    protected void rollbackConnections() {
        Enumeration enumeration = this._conns.elements();
        while (enumeration.hasMoreElements()) {
            Connection conn = (Connection)enumeration.nextElement();
            try {
                if (!this._globalTx) {
                    conn.rollback();
                }
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this._conns.clear();
    }

    public Object getConnection(LockEngine engine) throws PersistenceException {
        Connection conn = (Connection)this._conns.get(engine);
        if (conn == null) {
            try {
                conn = DatabaseRegistry.createConnection(engine);
                if (!this._globalTx) {
                    conn.setAutoCommit(false);
                }
                this._conns.put(engine, conn);
            }
            catch (SQLException except) {
                throw new PersistenceException(Messages.format("persist.nested", except), except);
            }
        }
        return conn;
    }
}

