/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber;

import com.echomine.common.SendMessageFailedException;
import com.echomine.jabber.AgentsIQMessage;
import com.echomine.jabber.BrowseIQMessage;
import com.echomine.jabber.JIDType;
import com.echomine.jabber.JabberConnection;
import com.echomine.jabber.JabberContext;
import com.echomine.jabber.JabberMessageException;
import com.echomine.jabber.LastIQMessage;
import com.echomine.jabber.TimeIQMessage;
import com.echomine.jabber.VersionIQMessage;
import java.util.List;

public class JabberServerService {
    private JabberContext context;
    private JabberConnection connection;

    public JabberServerService(JabberConnection connection, JabberContext context) {
        this.connection = connection;
        this.context = context;
    }

    public String getServerTimeInLocal() throws SendMessageFailedException {
        TimeIQMessage msg = new TimeIQMessage();
        msg.setSynchronized(true);
        msg.setTo(this.context.getServerName());
        this.connection.send(msg);
        TimeIQMessage reply = (TimeIQMessage)msg.getReplyMessage();
        if (reply != null) {
            return reply.getTimeInLocal().toString();
        }
        return null;
    }

    public String getServerTime() throws SendMessageFailedException {
        TimeIQMessage msg = new TimeIQMessage();
        msg.setSynchronized(true);
        msg.setTo(this.context.getServerName());
        this.connection.send(msg);
        TimeIQMessage reply = (TimeIQMessage)msg.getReplyMessage();
        if (reply != null) {
            return reply.getDisplay().toString();
        }
        return null;
    }

    public String getServerVersion() throws SendMessageFailedException {
        VersionIQMessage msg = new VersionIQMessage();
        msg.setSynchronized(true);
        msg.setTo(this.context.getServerName());
        this.connection.send(msg);
        VersionIQMessage reply = (VersionIQMessage)msg.getReplyMessage();
        String version = null;
        if (reply != null) {
            version = reply.getName() + " " + reply.getVersion();
        }
        return version;
    }

    public long getServerUptime() throws SendMessageFailedException {
        LastIQMessage msg = new LastIQMessage();
        msg.setTo(this.context.getServerName());
        msg.setSynchronized(true);
        this.connection.send(msg);
        LastIQMessage reply = (LastIQMessage)msg.getReplyMessage();
        if (reply != null) {
            return reply.getSeconds();
        }
        return -1;
    }

    public List getAgents() throws SendMessageFailedException {
        AgentsIQMessage msg = new AgentsIQMessage();
        msg.setSynchronized(true);
        msg.setTo(this.context.getServerName());
        this.connection.send(msg);
        AgentsIQMessage reply = (AgentsIQMessage)msg.getReplyMessage();
        if (reply != null) {
            return reply.getAgentList();
        }
        return null;
    }

    public JIDType browse(String jid, String type, boolean wait) throws JabberMessageException, SendMessageFailedException {
        BrowseIQMessage msg = new BrowseIQMessage("get", type);
        JIDType jidtype = msg.getJIDType();
        msg.setTo(jid);
        jidtype.setJID(jid);
        msg.setSynchronized(wait);
        this.connection.send(msg);
        if (wait) {
            if (msg.isError()) {
                throw new JabberMessageException(msg.getErrorMessage());
            }
            BrowseIQMessage reply = (BrowseIQMessage)msg.getReplyMessage();
            if (reply != null) {
                return reply.getJIDType();
            }
        }
        return null;
    }
}

