/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber;

import com.echomine.jabber.JabberMessage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public class MessageRequestQueue {
    private LinkedList msgQueue = new LinkedList();
    private HashMap msgReplyTable = new HashMap(30);
    private boolean shutdown;

    public void addMessage(JabberMessage msg) {
        if (!this.shutdown) {
            Cloneable cloneable;
            if (msg.isReplyRequired()) {
                cloneable = this.msgReplyTable;
                synchronized (cloneable) {
                    try {
                        this.msgReplyTable.put(msg.getMessageID(), msg);
                    }
                    catch (Throwable throwable) {
                        Object var5_5 = null;
                        throw throwable;
                    }
                }
            }
            cloneable = this.msgQueue;
            synchronized (cloneable) {
                try {
                    this.msgQueue.addLast(msg);
                    this.msgQueue.notify();
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    throw throwable;
                }
            }
        }
    }

    public JabberMessage waitForMessage() {
        JabberMessage msg;
        block7: {
            msg = null;
            try {
                if (this.shutdown) break block7;
                LinkedList linkedList = this.msgQueue;
                synchronized (linkedList) {
                    try {
                        if (this.msgQueue.size() == 0 && !this.shutdown) {
                            this.msgQueue.wait();
                        }
                        if (this.msgQueue.size() > 0 && !this.shutdown) {
                            msg = (JabberMessage)this.msgQueue.removeFirst();
                        }
                    }
                    catch (Throwable throwable) {
                        Object var5_5 = null;
                        throw throwable;
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return msg;
    }

    public void shutdown() {
        this.shutdown = true;
        Cloneable cloneable = this.msgQueue;
        synchronized (cloneable) {
            try {
                this.msgQueue.notifyAll();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                throw throwable;
            }
        }
        cloneable = this.msgReplyTable;
        synchronized (cloneable) {
            try {
                Iterator iter = this.msgReplyTable.values().iterator();
                while (iter.hasNext()) {
                    JabberMessage msg = (JabberMessage)iter.next();
                    msg.interrupt();
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                throw throwable;
            }
        }
    }

    public JabberMessage getMessageForReply(String id) {
        JabberMessage msg = null;
        HashMap hashMap = this.msgReplyTable;
        synchronized (hashMap) {
            try {
                msg = (JabberMessage)this.msgReplyTable.remove(id);
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                throw throwable;
            }
        }
        return msg;
    }

    public void clear() {
        Cloneable cloneable = this.msgQueue;
        synchronized (cloneable) {
            try {
                this.msgQueue.clear();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                throw throwable;
            }
        }
        cloneable = this.msgReplyTable;
        synchronized (cloneable) {
            try {
                this.msgReplyTable.clear();
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                throw throwable;
            }
        }
    }

    public void start() {
        this.shutdown = false;
    }
}

