/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.util.junit;

import com.echomine.util.IPUtil;
import junit.framework.TestCase;

public class IPUtilTest
extends TestCase {
    public IPUtilTest(String name) {
        super(name);
    }

    public void testPrivateIP() throws Exception {
        boolean isprivate = IPUtil.isHostIPPrivate("127.0.0.1");
        IPUtilTest.assertTrue((String)"127.0.0.1 should be private", (isprivate ? 1 : 0) != 0);
        isprivate = IPUtil.isHostIPPrivate("10.1.3.5");
        IPUtilTest.assertTrue((String)"10.0.0.0/8 should be private", (isprivate ? 1 : 0) != 0);
        isprivate = IPUtil.isHostIPPrivate("192.168.1.1");
        IPUtilTest.assertTrue((String)"192.168.0.0/16 should be private", (isprivate ? 1 : 0) != 0);
        isprivate = IPUtil.isHostIPPrivate("0.0.0.0");
        IPUtilTest.assertTrue((String)"0.0.0.0/32 should be private", (isprivate ? 1 : 0) != 0);
    }

    public void testSerializationDeserialization() throws Exception {
        byte[] buf = new byte[20];
        int offset = 0;
        String ip = "127.0.0.1";
        offset = IPUtil.serializeIP(ip, buf, 0);
        StringBuffer outbuf = new StringBuffer();
        IPUtil.deserializeIP(buf, 0, outbuf);
        String newip = outbuf.toString();
        IPUtilTest.assertEquals((Object)ip, (Object)newip);
    }
}

