/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.xmlrpc;

import com.echomine.xmlrpc.Serializer;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.jdom.Element;
import org.jdom.Namespace;

public class DateSerializer
implements Serializer {
    private TimeZone tz;
    private SimpleDateFormat format;

    public Element serialize(Object data, Namespace ns) {
        if (!(data instanceof Date)) {
            return null;
        }
        Element root = new Element(this.getName(), ns);
        SimpleDateFormat simpleDateFormat = this.format;
        synchronized (simpleDateFormat) {
            try {
                root.setText(this.format.format((Date)data));
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                throw throwable;
            }
        }
        return root;
    }

    public Object deserialize(Element elem) {
        String text = elem.getText();
        if (text == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = this.format;
        synchronized (simpleDateFormat) {
            try {
                Date date = this.format.parse(text, new ParsePosition(0));
                Object var6_6 = null;
                return date;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                throw throwable;
            }
        }
    }

    public String getName() {
        return "dateTime.iso8601";
    }

    public void setTimeZone(TimeZone tz) {
        this.tz = tz;
        if (tz != null) {
            this.format.setTimeZone(tz);
        }
    }
}

