/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema;

import java.util.Enumeration;
import java.util.Vector;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.AttributeGroup;
import org.exolab.castor.xml.schema.AttributeGroupEnumeration;
import org.exolab.castor.xml.schema.AttributeGroupReference;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.schema.Wildcard;

public final class AttributeGroupDecl
extends AttributeGroup {
    private static String NULL_ARGUMENT = "A null argument was passed to the constructor of " + (class$org$exolab$castor$xml$schema$AttributeDecl == null ? (class$org$exolab$castor$xml$schema$AttributeDecl = AttributeGroupDecl.class$("org.exolab.castor.xml.schema.AttributeDecl")) : class$org$exolab$castor$xml$schema$AttributeDecl).getName();
    private String _name = null;
    private Schema _schema = null;
    private Vector _attributes = null;
    private Vector _references = null;
    private Wildcard _anyAttribute = null;
    static /* synthetic */ Class class$org$exolab$castor$xml$schema$AttributeDecl;

    public AttributeGroupDecl(Schema schema) {
        if (schema == null) {
            String err = NULL_ARGUMENT + "; 'schema' must not be null.";
            throw new IllegalArgumentException(err);
        }
        this._schema = schema;
        this._attributes = new Vector();
        this._references = new Vector();
    }

    public void addAttribute(AttributeDecl attrDecl) {
        if (attrDecl == null) {
            return;
        }
        this._attributes.addElement(attrDecl);
        attrDecl.setParent(this);
    }

    public void addReference(AttributeGroupReference attrGroup) {
        if (attrGroup == null) {
            return;
        }
        this._references.addElement(attrGroup);
    }

    public Enumeration getLocalAttributes() {
        return this._attributes.elements();
    }

    public Enumeration getLocalAttributeGroupReferences() {
        return this._references.elements();
    }

    public Wildcard getAnyAttribute() {
        return this._anyAttribute;
    }

    public AttributeDecl getAttribute(String name) {
        if (name == null) {
            return null;
        }
        int i = 0;
        while (i < this._attributes.size()) {
            AttributeDecl attr = (AttributeDecl)this._attributes.elementAt(i);
            if (name.equals(attr.getName())) {
                return attr;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this._references.size()) {
            AttributeGroupReference ref = (AttributeGroupReference)this._references.elementAt(i2);
            AttributeDecl attr = ref.getAttribute(name);
            if (attr != null) {
                return attr;
            }
            ++i2;
        }
        return null;
    }

    public Enumeration getAttributes() {
        return new AttributeGroupEnumeration(this._attributes, this._references);
    }

    public String getName() {
        return this._name;
    }

    public Schema getSchema() {
        return this._schema;
    }

    public boolean isEmpty() {
        if (this._attributes.size() > 0) {
            return false;
        }
        if (this._references.size() == 0) {
            return true;
        }
        int i = 0;
        while (i < this._references.size()) {
            if (!((AttributeGroup)this._references.elementAt(i)).isEmpty()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean removeAttribute(AttributeDecl attr) {
        if (attr == null) {
            return false;
        }
        if (this._attributes.contains(attr)) {
            this._attributes.removeElement(attr);
            return true;
        }
        return false;
    }

    public boolean removeReference(AttributeGroupReference attrGroupReference) {
        if (attrGroupReference == null) {
            return false;
        }
        if (this._references.contains(attrGroupReference)) {
            this._references.removeElement(attrGroupReference);
            return true;
        }
        return false;
    }

    public void setAnyAttribute(Wildcard wildcard) throws SchemaException {
        if (wildcard != null) {
            if (this._anyAttribute != null) {
                String err = "<anyAttribute> already set in this AttributeGroup: " + this.getName();
                throw new SchemaException(err);
            }
            if (!wildcard.isAttributeWildcard()) {
                String err = "In AttributeGroup, " + this.getName() + "the wildcard must be an <anyAttribute>";
                throw new SchemaException(err);
            }
        }
        this._anyAttribute = wildcard;
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        int idx = name.indexOf(58);
        this._name = idx >= 0 ? name.substring(idx + 1) : name;
    }

    public short getStructureType() {
        return 4;
    }

    public void validate() throws ValidationException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

