/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;

class LsortCmd
implements Command {
    private static final String[] validOpts = new String[]{"-ascii", "-command", "-decreasing", "-dictionary", "-increasing", "-index", "-integer", "-real"};

    LsortCmd() {
    }

    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length < 2) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "?options? list");
        }
        String string = null;
        int n = 0;
        int n2 = -1;
        boolean bl = true;
        int n3 = 1;
        while (n3 < tclObjectArray.length - 1) {
            int n4 = TclIndex.get(interp, tclObjectArray[n3], validOpts, "option", 0);
            switch (n4) {
                case 0: {
                    n = 0;
                    break;
                }
                case 1: {
                    if (n3 == tclObjectArray.length - 2) {
                        throw new TclException(interp, "\"-command\" option must be followed by comparison command");
                    }
                    n = 3;
                    string = tclObjectArray[n3 + 1].toString();
                    ++n3;
                    break;
                }
                case 2: {
                    bl = false;
                    break;
                }
                case 3: {
                    n = 4;
                    break;
                }
                case 4: {
                    bl = true;
                    break;
                }
                case 5: {
                    if (n3 == tclObjectArray.length - 2) {
                        throw new TclException(interp, "\"-index\" option must be followed by list index");
                    }
                    n2 = TclInteger.getForIndex(interp, tclObjectArray[n3 + 1], -2);
                    string = tclObjectArray[n3 + 1].toString();
                    ++n3;
                    break;
                }
                case 6: {
                    n = 1;
                    break;
                }
                case 7: {
                    n = 2;
                }
            }
            ++n3;
        }
        TclObject tclObject = tclObjectArray[tclObjectArray.length - 1];
        tclObject.preserve();
        tclObject = tclObject.takeExclusive();
        try {
            TclList.sort(interp, tclObject, n, n2, bl, string);
            interp.setResult(tclObject);
            Object var10_10 = null;
            tclObject.release();
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            tclObject.release();
            throw throwable;
        }
    }
}

