/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber;

import com.echomine.common.ParseException;
import org.apache.oro.text.perl.Perl5Util;

public class JID {
    private Perl5Util jidRE = new Perl5Util();
    private String node;
    private String host;
    private String resource;

    public JID(String jid) throws ParseException {
        if (!this.jidRE.match("m#(?:(.+)\\@)?([^/]+)(?:/(.+))?#", jid)) {
            throw new ParseException("JID has incorrect format");
        }
        this.node = this.jidRE.group(1);
        this.host = this.jidRE.group(2);
        this.resource = this.jidRE.group(3);
    }

    public JID(String node, String host, String resource) {
        this.node = node;
        this.host = host;
        this.resource = resource;
    }

    public String getNode() {
        return this.node;
    }

    public String getHost() {
        return this.host;
    }

    public String getResource() {
        return this.resource;
    }

    public String getUsername() {
        return this.getNode();
    }

    public String getJIDWithoutResource() {
        return this.node + "@" + this.host;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.node != null) {
            buf.append(this.node).append("@");
        }
        buf.append(this.host);
        if (this.resource != null) {
            buf.append("/").append(this.resource);
        }
        return buf.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        String jid = obj.toString();
        return this.toString().equals(jid.toString());
    }

    public static void main(String[] args) {
        try {
            System.out.println("test@blah/temp blah = " + new JID("test@blah/temp blah"));
            System.out.println("test@blah = " + new JID("test@blah"));
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
        try {
            System.out.println("test = " + new JID("test"));
        }
        catch (ParseException ex) {
            System.out.println("Error on test");
        }
        try {
            System.out.println("test@blah/ = " + new JID("test@blah/"));
        }
        catch (ParseException ex) {
            System.out.println("Error on test@blah/");
        }
    }
}

