/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber;

import com.echomine.common.ParseException;
import com.echomine.jabber.AbstractJabberMessage;
import com.echomine.jabber.DelayXMessage;
import com.echomine.jabber.EventXMessage;
import com.echomine.jabber.JabberCode;
import com.echomine.jabber.JabberMessage;
import com.echomine.jabber.JabberMessageParser;
import com.echomine.jabber.MessageID;
import com.echomine.jabber.PGPEncryptedXMessage;
import com.echomine.jabber.RosterXMessage;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class JabberChatMessage
extends AbstractJabberMessage {
    public static final String TYPE_NORMAL = "normal";
    public static final String TYPE_CHAT = "chat";
    public static final String TYPE_GROUPCHAT = "groupchat";
    public static final String TYPE_HEADLINE = "headline";
    private static Namespace htmlNS = Namespace.getNamespace((String)"http://www.w3.org/1999/xhtml");
    private String body;
    private String subject;
    private String threadID;

    public JabberChatMessage(String type) {
        super(type, new Element("message", JabberCode.XMLNS_CHAT));
        this.setThreadID(JabberChatMessage.generateThreadID());
    }

    public JabberChatMessage() {
        this(TYPE_NORMAL);
    }

    public JabberMessage parse(JabberMessageParser parser, Element msgTree) throws ParseException {
        super.parse(parser, msgTree);
        if (this.getType() == null) {
            this.setType(TYPE_NORMAL);
        }
        return this;
    }

    public String getBody() {
        if (this.body != null) {
            return this.body;
        }
        this.body = this.getDOM().getChildText("body", JabberCode.XMLNS_CHAT);
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
        this.getDOM().removeChild("body", JabberCode.XMLNS_CHAT);
        if (body != null) {
            Element temp = new Element("body", JabberCode.XMLNS_CHAT);
            temp.setText(body);
            this.getDOM().addContent(temp);
        }
    }

    public String getHTMLBody() {
        XMLOutputter os = this.getXMLOutputter();
        String htmlStr = null;
        Element html = this.getDOM().getChild("html", htmlNS);
        if (html != null) {
            htmlStr = os.outputString(html);
        }
        return htmlStr;
    }

    public void setHTMLBody(String html) {
        this.getDOM().removeChild("html", htmlNS);
        if (html == null) {
            return;
        }
        try {
            SAXBuilder builder = new SAXBuilder();
            Element elem = builder.build((Reader)new StringReader(html)).getRootElement();
            this.getDOM().addContent(elem);
        }
        catch (JDOMException jDOMException) {
            // empty catch block
        }
    }

    public String getSubject() {
        if (this.subject != null) {
            return this.subject;
        }
        this.subject = this.getDOM().getChildText("subject", JabberCode.XMLNS_CHAT);
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
        this.getDOM().removeChild("subject", JabberCode.XMLNS_CHAT);
        if (subject != null) {
            Element temp = new Element("subject", JabberCode.XMLNS_CHAT);
            temp.setText(subject);
            this.getDOM().addContent(temp);
        }
    }

    public String getThreadID() {
        if (this.threadID != null) {
            return this.threadID;
        }
        this.threadID = this.getDOM().getChildText("thread", JabberCode.XMLNS_CHAT);
        return this.threadID;
    }

    public void setThreadID(String threadID) {
        this.threadID = threadID;
        this.getDOM().removeChild("thread", JabberCode.XMLNS_CHAT);
        if (threadID != null) {
            Element temp = new Element("thread", JabberCode.XMLNS_CHAT);
            temp.setText(threadID);
            this.getDOM().addContent(temp);
        }
    }

    public boolean isRosterMessage() {
        JabberMessage msg = this.getXMessage(JabberCode.XMLNS_X_ROSTER.getURI());
        return msg != null;
    }

    public List getRosterList() {
        RosterXMessage msg = (RosterXMessage)this.getXMessage(JabberCode.XMLNS_X_ROSTER.getURI());
        if (msg == null) {
            return null;
        }
        return msg.getRosterItems();
    }

    public EventXMessage getEventMessage() {
        return (EventXMessage)this.getXMessage(JabberCode.XMLNS_X_EVENT.getURI());
    }

    public DelayXMessage getDelayMessage() {
        return (DelayXMessage)this.getXMessage(JabberCode.XMLNS_X_DELAY.getURI());
    }

    public PGPEncryptedXMessage getPGPMessage() {
        return (PGPEncryptedXMessage)this.getXMessage(JabberCode.XMLNS_X_PGP_ENCRYPTED.getURI());
    }

    public static String generateThreadID() {
        return MessageID.nextID();
    }

    public int getMessageType() {
        return 3;
    }
}

