/*
 * Copyright (C) 2003-2007 eXo Platform SAS.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see<http://www.gnu.org/licenses/>.
 */
package org.exoplatform.gwtframework.commons.component;

import java.util.HashMap;

import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.event.shared.GwtEvent.Type;

/**
 * Created by The eXo Platform SAS .
 * 
 * @author <a href="mailto:gavrikvetal@gmail.com">Vitaliy Gulyy</a>
 * @version @version $Id: $
 */

public class Handlers
{

   /**
    * Event Bus
    */
   private HandlerManager eventBus;

   private HashMap<Type<?>, HandlerRegistration> handlerRegistrations = new HashMap<Type<?>, HandlerRegistration>();

   public Handlers(HandlerManager eventBus)
   {
      this.eventBus = eventBus;
   }

   public <H extends EventHandler> HandlerRegistration addHandler(Type<H> type, H handler)
   {
      if (handlerRegistrations.get(type) != null)
      {
         new Exception("Handler already registered!").printStackTrace();
         handlerRegistrations.get(type).removeHandler();
      }

      HandlerRegistration h = eventBus.addHandler(type, handler);
      handlerRegistrations.put(type, h);
      return h;
   }

   public <H extends EventHandler> void removeHandler(Type<H> type)
   {
      if (handlerRegistrations.containsKey(type))
      {
         HandlerRegistration h = handlerRegistrations.get(type);
         handlerRegistrations.remove(type);
         h.removeHandler();
      }
   }

   public void removeHandlers()
   {
      for (HandlerRegistration h : handlerRegistrations.values())
      {
         h.removeHandler();
      }

      handlerRegistrations.clear();
   }

}
