/**
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 *
 */

package org.exoplatform.gwtframework.editor.event;

import java.util.List;

import org.exoplatform.gwtframework.editor.api.CodeError;

import com.google.gwt.event.shared.GwtEvent;

/**
 * Created by The eXo Platform SAS .
 * This event is fires after the user had been clicked on the code error mark in the editor.
 * @author <a href="mailto:dmitry.ndp@gmail.com">Dmytro Nochevnov</a>
 * @version @version $Id: $
 */

public class EditorErrorMarkClickedEvent extends GwtEvent<EditorErrorMarkClickedHandler>
{
   public static final GwtEvent.Type<EditorErrorMarkClickedHandler> TYPE =
      new GwtEvent.Type<EditorErrorMarkClickedHandler>();

   private String editorId;
   
   private List<CodeError> codeErrorList;

   private int markOffsetX;
   
   private int markOffsetY;

   private String fileMimeType;
   
   /**
    * Event should be fired just after the user is clicked on the Code Error Mark within the Code Editor
    * @param editorId
    * @param getErrorList
    * @param markOffsetX
    * @param markOffsetY
    */
   public EditorErrorMarkClickedEvent(String editorId, List<CodeError> codeErrorList, int markOffsetX, int markOffsetY, String fileMimeType)
   {
      this.editorId = editorId;
      
      this.codeErrorList = codeErrorList;
      
      this.fileMimeType = fileMimeType;
      
      this.markOffsetX = markOffsetX;
      
      this.markOffsetY = markOffsetY;
   }

   @Override
   protected void dispatch(EditorErrorMarkClickedHandler handler)
   {
      handler.onEditorErrorMarkClicked(this);
   }

   @Override
   public com.google.gwt.event.shared.GwtEvent.Type<EditorErrorMarkClickedHandler> getAssociatedType()
   {
      return TYPE;
   }

   /**
    * 
    * @return id of editor in which this event was happened
    */
   public String getEditorId()
   { 
      return this.editorId;
   }

   /**
    * 
    * @return list of code errors which occured in the line with mark, clicked by user 
    */
   public List<CodeError> getCodeErrorList()
   {
      return codeErrorList;
   }

   /**
    * 
    * @return code error mark offset from the left border of Code Editor panel
    */   
   public int getMarkOffsetX()
   {
      return markOffsetX;
   }

   /**
    * 
    * @return code error mark offset from the top of Code Editor panel
    */
   public int getMarkOffsetY()
   {
      return markOffsetY;
   }

   /**
    * 
    * @return mime type of file with code error
    */
   public String getFileMimeType()
   {
      return fileMimeType;
   }   
}