/**
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 *
 */

package org.exoplatform.gwtframework.ui.client.smartgwt.component;

import java.util.ArrayList;
import java.util.List;

import org.exoplatform.gwtframework.ui.client.api.ListGridItem;
import org.exoplatform.gwtframework.ui.client.smartgwt.component.data.SelectionHandlerImpl;
import org.exoplatform.gwtframework.ui.client.smartgwt.component.event.ClickHandlerImpl;
import org.exoplatform.gwtframework.ui.client.smartgwt.component.event.DoubleClickHandlerImpl;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.DoubleClickHandler;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.smartgwt.client.widgets.grid.ListGridRecord;

/**
 * Created by The eXo Platform SAS .
 * 
 * @author <a href="mailto:gavrikvetal@gmail.com">Vitaliy Gulyy</a>
 * @version $
 */

public abstract class ListGrid<T> extends com.smartgwt.client.widgets.grid.ListGrid implements ListGridItem<T>
{

   private String valuePropertyName = getClass().getName();

   protected String getValuePropertyName()
   {
      return valuePropertyName;
   }

   public HandlerRegistration addClickHandler(ClickHandler clickHandler)
   {
      return super.addClickHandler(new ClickHandlerImpl(clickHandler));
   }

   public HandlerRegistration addDoubleClickHandler(DoubleClickHandler doubleClickHandler)
   {
      return super.addDoubleClickHandler(new DoubleClickHandlerImpl(doubleClickHandler));
   }

   protected List<T> items;

   public List<T> getValue()
   {
      return items;
   }

   public void setValue(List<T> items)
   {
      this.items = items;

      updateRecords();
   }

   protected void updateRecords()
   {
      ListGridRecord[] recs = new ListGridRecord[items.size()];

      int i = 0;
      for (T item : items)
      {
         ListGridRecord record = new ListGridRecord();
         record.setAttribute(getValuePropertyName(), item);

         setRecordFields(record, item);

         recs[i] = record;
         i++;
      }

      setRecords(recs);
   }

   protected String tune(String value)
   {
      return "<div title=\"" + value + "\">" + ("".equals(value) ? "&nbsp;" : value) + "</div>";
   }

   protected abstract void setRecordFields(ListGridRecord record, T item);

   public void setValue(List<T> items, boolean fireEvents)
   {
      setValue(items);
   }

   protected ArrayList<ValueChangeHandler<List<T>>> valueChangeHandlers = new ArrayList<ValueChangeHandler<List<T>>>();

   public HandlerRegistration addValueChangeHandler(ValueChangeHandler<List<T>> valueChangeHandler)
   {
      valueChangeHandlers.add(valueChangeHandler);
      return new HandlerRegistration()
      {
         public void removeHandler()
         {
         }
      };
   }

   public HandlerRegistration addSelectionHandler(SelectionHandler<T> selectionHandler)
   {
      return super.addSelectionChangedHandler(new SelectionHandlerImpl<T>(selectionHandler, getValuePropertyName()));
   }

}
