/**
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 *
 */

package org.exoplatform.gwtframework.ui.client.smartgwt.component.event;

import com.google.gwt.event.dom.client.KeyCodes;
import com.google.gwt.event.dom.client.KeyPressEvent;

/**
 * Created by The eXo Platform SAS .
 * 
 * @author <a href="mailto:dmitry.ndp@gmail.com">Dmytro Nochevnov</a>
 * @version $
 */

public class KeyPressWidgetEventImpl extends KeyPressEvent 
{
   private String keyName;
   private boolean isCtrlKeyDown;
   private boolean isAltKeyDown;

   @Deprecated
   public KeyPressWidgetEventImpl(String keyName)
   {
      this(keyName, false, false);
   }
   
   public KeyPressWidgetEventImpl(String keyName, boolean isCtrlKeyDown, boolean isAltKeyDown)
   {
      this.keyName = keyName;
      this.isCtrlKeyDown = isCtrlKeyDown;
      this.isAltKeyDown = isAltKeyDown;
   }

   @Override
   public char getCharCode()
   {
      if (keyName == null)
      {
         return 0;
      }
      
      return getCharCodeOnKeyName(keyName);
   }   
 
   @Override
   public boolean isAltKeyDown()
   {
      return isAltKeyDown;
   }
   
   @Override
   public boolean isControlKeyDown()
   {
      return isCtrlKeyDown;
   }
   
   private char getCharCodeOnKeyName(String keyName)
   {
      // test is there alphabetic symbol key pressed
      if (keyName.length() == 1)
      {
         return keyName.charAt(0);
      }
      
      else if (keyName.equals(com.smartgwt.client.types.KeyNames.ENTER))
      {
         return KeyCodes.KEY_ENTER;  // It is impossible to handle Enter key pressing event within the TreeGrid and ListGrid in the SmartGWT 2.2 because of bug when Enter keypress is not caugth (http://code.google.com/p/smartgwt/issues/detail?id=430).
      }

      else if (keyName.equals(com.smartgwt.client.types.KeyNames.DEL))
      {
         return KeyCodes.KEY_DELETE;         
      }      
      
      // arrow-up, arrow-down, arrow-left, arrow-right keys weren't caught.  
      
      else if (keyName.equals(com.smartgwt.client.types.KeyNames.ESC))
      {
         return KeyCodes.KEY_ESCAPE;         
      }
      
      return 0;
   }
   
}
