/**
 * Copyright (C) 2010 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 *
 */

package org.exoplatform.gwtframework.ui.client.testcase.cases;

import org.exoplatform.gwtframework.ui.client.api.ButtonItem;
import org.exoplatform.gwtframework.ui.client.loader.LoadingIndicator;
import org.exoplatform.gwtframework.ui.client.testcase.ShowCaseImageBundle;
import org.exoplatform.gwtframework.ui.client.testcase.TestCase;
import org.exoplatform.gwtframework.ui.client.util.ImageHelper;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.FlowPanel;

/**
 * 
 * Created by The eXo Platform SAS .
 * 
 * @author <a href="mailto:gavrikvetal@gmail.com">Vitaliy Gulyy</a>
 * @version $
 */

public class LoadingIndicatorTestCase extends TestCase
{

   private LoadingIndicator loader;

   private ButtonItem showHideLoaderButton;

   private ButtonItem showHideIconButton;

   private ButtonItem changeIconButton;

   private ButtonItem enableDisableCommandButton;

   private String searchIcon;

   private String cancelIcon;

   @Override
   public void draw()
   {
      FlowPanel panel = new FlowPanel();
      DOM.setStyleAttribute(panel.getElement(), "position", "relative");
      DOM.setStyleAttribute(panel.getElement(), "left", "50px");
      DOM.setStyleAttribute(panel.getElement(), "top", "50px");
      DOM.setStyleAttribute(panel.getElement(), "width", "300px");
      DOM.setStyleAttribute(panel.getElement(), "height", "100px");
      //DOM.setStyleAttribute(loaderComponentPanel.getElement(), "background", "#FFAAEE");
      testCasePanel().add(panel);

      searchIcon = ImageHelper.getImageHTML(ShowCaseImageBundle.INSTANCE.search());
      cancelIcon = ImageHelper.getImageHTML(ShowCaseImageBundle.INSTANCE.cancel());

      loader = new LoadingIndicator(searchIcon);
      loader.setCommand(loaderCommand);
      //loader = new Loader();
      panel.add(loader);

      addButtonHeader("Visibility:");
      showHideLoaderButton = createButton("Hide Loader", showHideLoaderButtonClickHandler);
      addButtonDelimiter("Icon:");
      showHideIconButton = createButton("Hide Icon", showHideIconButtonClickHandler);
      changeIconButton = createButton("Change Icon", changeIconButtonClickHandler);
      addButtonDelimiter("Command");
      enableDisableCommandButton = createButton("Disable Command", enableDisableCommandButtonClickHandler);
   }
   
   private ClickHandler showHideLoaderButtonClickHandler = new ClickHandler()
   {
      public void onClick(ClickEvent event)
      {
         if (loader.isVisible())
         {
            loader.setVisible(false);
            showHideLoaderButton.setTitle("Show Loader");
            showHideLoaderButton.setText("Show Loader");
         }
         else
         {
            loader.setVisible(true);
            showHideLoaderButton.setTitle("Hide Loader");
            showHideLoaderButton.setText("Hide Loader");
         }

      }
   };

   private ClickHandler showHideIconButtonClickHandler = new ClickHandler()
   {
      public void onClick(ClickEvent event)
      {
         if (loader.getIcon() != null)
         {
            loader.setIcon(null);
            showHideIconButton.setText("Show Icon");
         }
         else
         {
            loader.setIcon(searchIcon);
            showHideIconButton.setText("Hide Icon");
         }

      }
   };

   private ClickHandler changeIconButtonClickHandler = new ClickHandler()
   {
      public void onClick(ClickEvent event)
      {
         if (searchIcon.equals(loader.getIcon()))
         {
            loader.setIcon(cancelIcon);
         }
         else
         {
            loader.setIcon(searchIcon);
         }

         showHideIconButton.setText("Hide Icon");
         showHideIconButton.setTitle("Hide Icon");
      }
   };

   private ClickHandler enableDisableCommandButtonClickHandler = new ClickHandler()
   {
      public void onClick(ClickEvent event)
      {
         if (loader.getCommand() != null)
         {
            loader.setCommand(null);
            enableDisableCommandButton.setText("Enable Command");
            enableDisableCommandButton.setTitle("Enable Command");
         }
         else
         {
            loader.setCommand(loaderCommand);
            enableDisableCommandButton.setText("Disable Command");
            enableDisableCommandButton.setTitle("Disable Command");
         }
      }
   };

   private Command loaderCommand = new Command()
   {
      public void execute()
      {
         Window.alert("Loader button clicked!");
      }
   };

}
