/**
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 *
 */

package org.exoplatform.gwtframework.commons.xml;

import java.util.HashMap;
import java.util.Map;

import com.google.gwt.xml.client.Document;
import com.google.gwt.xml.client.XMLParser;

/**
 * Created by The eXo Platform SAS        .
 * 
 * Utility for XML document creation (mostly for namespace management purpose)
 * 
 * @version $Id: $
 */

public class DocumentCreator
{

   // prefix -> namespace
   private static HashMap<String, String> namespaces = new HashMap<String, String>();

   // namespace -> prefix
   private static HashMap<String, String> prefixes = new HashMap<String, String>();

   static
   {
      addNamespace("DAV:", "D");
      addNamespace("http://www.jcp.org/jcr/1.0", "jcr");
      addNamespace("http://www.jcp.org/mix/1.0", "mix");
      addNamespace("http://www.exoplatform.com/jcr/exo/1.0", "exo");
   }

   public static void addNamespace(String namespace, String prefix)
   {
      namespaces.put(prefix, namespace);
      prefixes.put(namespace, prefix);
   }

   public static Document createDocument()
   {
      Document doc = XMLParser.createDocument();
      // TODO resolve namespaces in run time
      for (Map.Entry<String, String> entry : namespaces.entrySet())
      {
         doc.getDocumentElement().setAttribute("xmlns:" + entry.getKey(), entry.getValue());
      }
      return doc;
   }

}
