/*
 * Copyright (C) 2011 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.exoplatform.gwtframework.ui.client.smartgwt.component.data;

import com.google.gwt.event.logical.shared.CloseHandler;
import com.smartgwt.client.widgets.tree.events.FolderClosedEvent;
import com.smartgwt.client.widgets.tree.events.FolderClosedHandler;

import org.exoplatform.gwtframework.ui.client.smartgwt.component.event.CloseEventImpl;


/**
 * Implementation of {@link FolderClosedHandler}.
 * 
 * @author <a href="mailto:zhulevaanna@gmail.com">Ann Zhuleva</a>
 * @version $Id:  Jan 17, 2011 4:46:48 PM anya $
 *
 * @param <T>
 */
public class FolderClosedHandlerImpl<T> implements FolderClosedHandler
{
   /**
    * The close handler.
    */
   private CloseHandler<T> closeHandler;

   /**
    * Value's property name.
    */
   private String valuePropertyName;

   /**
    * @param closeHandler close handler
    * @param valuePropertyName value's property name
    */
   public FolderClosedHandlerImpl(CloseHandler<T> closeHandler, String valuePropertyName)
   {
      this.closeHandler = closeHandler;
      this.valuePropertyName = valuePropertyName;
   }

   /**
    * @see com.smartgwt.client.widgets.tree.events.FolderClosedHandler#onFolderClosed(com.smartgwt.client.widgets.tree.events.FolderClosedEvent)
    */
   @SuppressWarnings("unchecked")
   public void onFolderClosed(FolderClosedEvent event)
   {
      T target = (T)event.getNode().getAttributeAsObject(valuePropertyName);
      closeHandler.onClose(new CloseEventImpl<T>(target));
   }
}
