/**
 * Copyright (C) 2010 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 *
 */

package org.exoplatform.gwtframework.ui.client.testcase.cases;

import org.exoplatform.gwtframework.ui.client.testcase.ShowCaseImageBundle;
import org.exoplatform.gwtframework.ui.client.testcase.TestCase;
import org.exoplatform.gwtframework.ui.client.text.TextInput;
import org.exoplatform.gwtframework.ui.client.util.ImageHelper;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.FlowPanel;

/**
 * 
 * Created by The eXo Platform SAS .
 * 
 * @author <a href="mailto:gavrikvetal@gmail.com">Vitaliy Gulyy</a>
 * @version $
 */

public class TextInputTestCase extends TestCase
{
   
   private String icon;
   
   private String disabledIcon;

   @Override
   public void draw()
   {
      FlowPanel panel = new FlowPanel();
      DOM.setStyleAttribute(panel.getElement(), "position", "relative");
      DOM.setStyleAttribute(panel.getElement(), "left", "50px");
      DOM.setStyleAttribute(panel.getElement(), "top", "50px");
      DOM.setStyleAttribute(panel.getElement(), "width", "250px");
      DOM.setStyleAttribute(panel.getElement(), "height", "100px");
      //DOM.setStyleAttribute(panel.getElement(), "background", "#FFAAEE");
      testCasePanel().add(panel);
      
      icon = ImageHelper.getImageHTML(ShowCaseImageBundle.INSTANCE.search());
      disabledIcon = ImageHelper.getImageHTML(ShowCaseImageBundle.INSTANCE.searchDisabled());
      
      TextInput textInput = new TextInput(icon, disabledIcon, 240, "yA!", null);
      panel.add(textInput);      
   }

}
