/**
 * Copyright (C) 2010 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 *
 */

package org.exoplatform.gwtframework.ui.client.toolbar;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;

/**
 * 
 * Created by The eXo Platform SAS .
 * 
 * @author <a href="mailto:gavrikvetal@gmail.com">Vitaliy Gulyy</a>
 * @version $
 */

public class ToolbarItem extends Composite
{

   /**
    * Styles for HTML elemnts of toolbar component.
    */
   protected interface Style
   {

      static final String ITEM_LEFT = "exoToolbarElementLeft";

      static final String ITEM_RIGHT = "exoToolbarElementRight";

      static final String DELIMITER = "exoToolbarDelimiter";

   }

   /**
    * HTML element of this Toolbar Item.
    */
   private FlowPanel panel;

   /**
    * Docking of the item in the toolbar.
    * <code>false</code> - element is left side,
    * <code>true<code> - element is right side.
    */
   private boolean rightDocked = false;

   /**
    * Is this element is toolbar delimiter.
    */
   private boolean delimiter = false;

   /**
    * Create new ToolbarItem instance.
    * 
    * @param item element to be added to the toolbar.
    */
   public ToolbarItem(Widget item)
   {
      this(item, false);
   }

   /**
    * Create new ToolbarItem instance.
    *
    * @param item element to be added to the toolbar.
    * @param topPadding  
    */
   public ToolbarItem(Widget item, int topPadding)
   {
      this(item, false, topPadding);
   }

   /**
    * @param item
    * @param rightDocked
    */
   public ToolbarItem(Widget item, boolean rightDocked)
   {
      this(item, rightDocked, 4);
   }

   /**
    * @param item
    * @param rightDocked
    * @param margin
    */
   public ToolbarItem(Widget item, boolean rightDocked, int topPadding)
   {
      this.rightDocked = rightDocked;

      panel = new FlowPanel();
      initWidget(panel);
      panel.setStyleName(rightDocked ? Style.ITEM_RIGHT : Style.ITEM_LEFT);

      DOM.setStyleAttribute(panel.getElement(), "paddingTop", "" + topPadding + "px");

      if (item == null)
      {
         item = new FlowPanel();
         item.setStyleName(Style.DELIMITER);
         panel.add(item);
         delimiter = true;
      }

      panel.add(item);
   }

   /**
    * Get docking of the item in the toolbar.
    * <code>false</code> - element is left side,
    * <code>true<code> - element is right side.
    * 
    * @return docking of the item in the toolbar
    */
   public boolean isRightDocked()
   {
      return rightDocked;
   }

   /**
    * Get is this element is toolbar delimiter.
    * 
    * @return is this element is toolbar delimiter.
    */
   public boolean isDelimiter()
   {
      return delimiter;
   }

}
