/**
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 *
 */

package org.exoplatform.gwtframework.commons.xml;

import org.exoplatform.gwtframework.commons.xml.XMLFinder;
import org.exoplatform.gwtframework.commons.xml.XMLNodeNotFoundException;

import com.google.gwt.junit.client.GWTTestCase;
import com.google.gwt.xml.client.Document;
import com.google.gwt.xml.client.XMLParser;

/**
 * Created by The eXo Platform SAS.
 * @author <a href="mailto:vitaly.parfonov@gmail.com">Vitaly Parfonov</a>
 * @version $Id: $
 */
public class GwtTestXMLFinder extends GWTTestCase
{

   private static String conf =
      "<?xml version=\"1.0\" ?><BackupManager jcr:primaryType=\"exo:registryEntry\">"
         + "<context jcr:primaryType=\"nt:unstructured\">portal/rest</context>"
         + "<repository jcr:primaryType=\"nt:unstructured\">repository</repository>"
         + "<workspace jcr:primaryType=\"nt:unstructured\">collaboration</workspace>" + "<emptynode/>"
         + "</BackupManager>";

   /**
    * {@inheritDoc}
    */
   @Override
   public String getModuleName()
   {
      return "org.exoplatform.gwt.commons.CommonsJUnit";
   }

   public void testGetAtrribute() throws XMLNodeNotFoundException
   {
      Document doc = XMLParser.parse(conf);
      XMLParser.removeWhitespace(doc);
      String attr = XMLFinder.findAttribute(doc, "BackupManager/workspace", "jcr:primaryType");
      assertNotNull(attr);
      assertEquals("nt:unstructured", attr);
   }

   public void testGetAtrributeNotFound()
   {
      Document doc = XMLParser.parse(conf);
      XMLParser.removeWhitespace(doc);
      try
      {
         XMLFinder.findAttribute(doc, "BackupManager/workspace", "noFound");
         fail();
      }
      catch (XMLNodeNotFoundException e)
      {
      }
   }

   public void testFindTextElement() throws XMLNodeNotFoundException
   {
      Document doc = XMLParser.parse(conf);
      XMLParser.removeWhitespace(doc);
      String text = XMLFinder.findTextElement(doc, "BackupManager/workspace");
      assertNotNull(text);
      assertEquals("collaboration", text);
   }

   public void testFindTextElementFromEmptyNode()
   {
      Document doc = XMLParser.parse(conf);
      XMLParser.removeWhitespace(doc);
      try
      {
         XMLFinder.findTextElement(doc, "BackupManager/emptynode");
         fail();
      }
      catch (XMLNodeNotFoundException e)
      {
      }
   }

   public void testFindTextNodeNotFound()
   {
      Document doc = XMLParser.parse(conf);
      XMLParser.removeWhitespace(doc);
      try
      {
         XMLFinder.findTextElement(doc, "NotFound/emptynode");
         fail();
      }
      catch (XMLNodeNotFoundException e)
      {
      }
   }

}
