/**
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 *
 */

package org.exoplatform.gwtframework.ui.client.smartgwt;

import org.exoplatform.gwtframework.commons.exception.ExceptionThrownEvent;
import org.exoplatform.gwtframework.commons.exception.ExceptionThrownHandler;
import org.exoplatform.gwtframework.commons.exception.ServerException;
import org.exoplatform.gwtframework.ui.client.util.UIHelper;

import com.smartgwt.client.types.Alignment;
import com.smartgwt.client.widgets.IButton;
import com.smartgwt.client.widgets.RichTextEditor;
import com.smartgwt.client.widgets.StatefulCanvas;
import com.smartgwt.client.widgets.Window;
import com.smartgwt.client.widgets.events.ClickEvent;
import com.smartgwt.client.widgets.events.ClickHandler;
import com.smartgwt.client.widgets.form.DynamicForm;
import com.smartgwt.client.widgets.form.fields.SpacerItem;
import com.smartgwt.client.widgets.form.fields.ToolbarItem;
import com.smartgwt.client.widgets.layout.VLayout;

/**
 * Created by The eXo Platform SAS .
 * 
 * @author <a href="mailto:gavrikvetal@gmail.com">Vitaliy Gulyy</a>
 * @version $
 * 
 * This handler shows exception message in most friendly window.
 * 
 */

public class SmartGWTExceptionThrownHandlerImpl implements ExceptionThrownHandler
{

   private Window window;
   
   public void onError(ExceptionThrownEvent event)
   {
      Throwable error = event.getError();

      String message;
      if (error instanceof ServerException)
      {
         ServerException serverException = (ServerException)error;

         message =
            "" + serverException.getHTTPStatus() + " : " + serverException.getStatusText() + "\r\n"
               + serverException.getMessage();
      }
      else
      {
         message = error.getMessage();
         error.printStackTrace();
      }

      window = new Window();
      window.setCanDragResize(true);
      window.setShowMaximizeButton(true);
      window.setShowMinimizeButton(false);
      window.setIsModal(true);
      window.setWidth(600);
      window.setHeight(400);
      window.setTitle("Error");

      VLayout layout = new VLayout();
      layout.setWidth100();
      layout.setHeight100();
      window.addItem(layout);

      RichTextEditor editor = new RichTextEditor();
      editor.setMargin(10);
      editor.setBorder("#a7abb4 1px solid");
      editor.setWidth100();
      editor.setHeight100();
      layout.addMember(editor);
      
      DynamicForm buttonsForm = getButtonsForm();
      layout.addMember(buttonsForm);

      editor.setValue(message);

      window.centerInPage();

      window.show();
   }
   
   private DynamicForm getButtonsForm()
   {
      DynamicForm buttonsForm = new DynamicForm();
      buttonsForm.setPadding(5);
      buttonsForm.setHeight(24);
      buttonsForm.setLayoutAlign(Alignment.CENTER);

      IButton okButton = new IButton("Ok");
      okButton.setWidth(90);
      okButton.setHeight(22);
      okButton.setIcon(UIHelper.getGadgetImagesURL() + "dialogs/ok.png");
      okButton.addClickHandler(new ClickHandler() {
         public void onClick(ClickEvent event)
         {
            window.destroy();
         }
      });
      
      ToolbarItem tbi = new ToolbarItem();
      StatefulCanvas delimiter1 = new StatefulCanvas();
      delimiter1.setWidth(3);
      tbi.setButtons(okButton);
      
      SpacerItem spacer = new SpacerItem();
      spacer.setHeight(5);
      
      buttonsForm.setFields(tbi, spacer);

      buttonsForm.setAutoWidth();
      return buttonsForm;
   }
   

}
