/**
 * Copyright (C) 2010 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 *
 */

package org.exoplatform.gwtframework.ui.client.text;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.TableElement;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;

/**
 * 
 * Created by The eXo Platform SAS .
 * 
 * @author <a href="mailto:gavrikvetal@gmail.com">Vitaliy Gulyy</a>
 * @version $
 */

public class TextInput extends Composite implements HasText
{

   public interface Style
   {

      static final String ICON = "exoTextInputButtonIcon";

      static final String TABLE_DOWN = "exoTextInputTableDown";

   }

   interface TextInputUiBinder extends UiBinder<Widget, TextInput>
   {
   }

   private static TextInputUiBinder uiBinder = GWT.create(TextInputUiBinder.class);

   private Command command;

   private String disabledIcon;

   private boolean enabled = true;

   private String icon;

   @UiField
   HTML iconPanel;

   @UiField
   TableElement table;

   @UiField
   TextBox textBox;

   private int width = 100;

   public TextInput(String icon, String disabledIcon, int width, String defaultValue, Command command)
   {
      this.icon = icon;
      this.disabledIcon = disabledIcon;
      this.width = width;

      initWidget(uiBinder.createAndBindUi(this));
      textBox.setText(defaultValue);
      setWidth("" + width + "px");
      renderIcon();
   }

   public Command getCommand()
   {
      return command;
   }

   public String getDisabledIcon()
   {
      return disabledIcon;
   }

   public String getIcon()
   {
      return icon;
   }

   public String getText()
   {
      return textBox.getText();
   }

   public int getWidth()
   {
      return width;
   }

   @UiHandler("iconPanel")
   void handleClick(ClickEvent e)
   {

   }

   @UiHandler("iconPanel")
   void handleMouseDown(MouseDownEvent e)
   {
      table.addClassName(Style.TABLE_DOWN);
   }

   @UiHandler("iconPanel")
   void handleMouseUp(MouseUpEvent e)
   {
      table.removeClassName(Style.TABLE_DOWN);
   }

   public boolean isEnabled()
   {
      return enabled;
   }

   /**
    * Redraw icon.
    */
   private void renderIcon()
   {
      if (enabled)
      {
         iconPanel.setHTML(icon);
         if (icon == null)
         {
            return;
         }
      }
      else
      {
         iconPanel.setHTML(disabledIcon);
         if (disabledIcon != null)
         {
            return;
         }
      }

      Element e = iconPanel.getElement();
      Element imageElement = DOM.getChild(e, 0);
      DOM.setElementAttribute(imageElement, "class", Style.ICON);
   }

   public void setCommand(Command command)
   {
      this.command = command;
   }

   public void setDisabledIcon(String disabledIcon)
   {
      this.disabledIcon = disabledIcon;
   }

   public void setEnabled(boolean enabled)
   {
      this.enabled = enabled;
   }

   public void setIcon(String icon)
   {
      this.icon = icon;
   }

   public void setText(String text)
   {
      textBox.setText(text);
   }

   public void setWidth(int width)
   {
      this.width = width;
      setWidth("" + width + "px");
   }
   
   public String getTitle()
   {
      return null;
   }

   public void setTitle(String title)
   {
   }

}
