/**
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 *
 */

package org.exoplatform.gwtframework.commons.initializer;

import com.google.gwt.json.client.JSONObject;

/**
 * Created by The eXo Platform SAS.
 * @author <a href="mailto:vitaly.parfonov@gmail.com">Vitaly Parfonov</a>
 * @version $Id: $
*/
public class ApplicationConfiguration
{
   private String appName;

   private JSONObject configuration;

   public ApplicationConfiguration()
   {
   }

   /**
    * @param appName
    * @param configuration
    */
   public ApplicationConfiguration(String appName, JSONObject configuration)
   {
      this.appName = appName;
      this.configuration = configuration;
   }

   /**
    * @return the appName
    */
   public String getAppName()
   {
      return appName;
   }

   /**
    * @param appName the appName to set
    */
   public void setAppName(String appName)
   {
      this.appName = appName;
   }

   /**
    * @return the configuration
    */
   public JSONObject getConfiguration()
   {
      return configuration;
   }

   /**
    * @param configuration the configuration to set
    */
   public void setConfiguration(JSONObject configuration)
   {
      this.configuration = configuration;
   }

}
