/**
 * Copyright (C) 2010 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 *
 */

package org.exoplatform.gwtframework.commons.webdav;

import java.util.ArrayList;
import java.util.List;

import org.exoplatform.gwtframework.commons.xml.QName;

/**
 * 
 * Created by The eXo Platform SAS .
 * 
 * @author <a href="mailto:gavrikvetal@gmail.com">Vitaliy Gulyy</a>
 * @version $
 */

public class Property
{
   
   QName name;

   String value;
   
   private List<Property> childProperties = new ArrayList<Property>();

   //private HashMap<QName, Property> childProperties = new HashMap<QName, Property>();

   public Property(QName name)
   {
      this.name = name;
      //this.childProperties = new HashMap<QName, Property>();
   }

   public final QName getName()
   {
      return name;
   }

   public final String getValue()
   {
      return value;
   }
   
   public final List<Property> getChildProperties()
   {
      return childProperties;
   }

   public final Property getChildProperty(QName name)
   {
      for (Property property : childProperties) {
         if (property.getName().equals(name)) {
            return property;
         }
      }
      return null;
   }
   
   /**
    * @param value the value to set
    */
   public void setValue(String value)
   {
      this.value = value;
   }   

}
