/**
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 *
 */

package org.exoplatform.gwtframework.commons.initializer.marshal;

import org.exoplatform.gwtframework.commons.initializer.ApplicationConfiguration;
import org.exoplatform.gwtframework.commons.initializer.event.ApplicationConfigurationReceivedFailedEvent;
import org.exoplatform.gwtframework.commons.rest.Unmarshallable;
import org.exoplatform.gwtframework.commons.xml.XMLFinder;
import org.exoplatform.gwtframework.commons.xml.XMLNodeNotFoundException;

import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.http.client.Response;
import com.google.gwt.json.client.JSONParser;
import com.google.gwt.xml.client.Document;
import com.google.gwt.xml.client.XMLParser;

/**
 * Created by The eXo Platform SAS.
 * @author <a href="mailto:vitaly.parfonov@gmail.com">Vitaly Parfonov</a>
 * @version $Id: $
*/
public class DefaultApplicationConfigurationUnmarshaler implements Unmarshallable
{

   private ApplicationConfiguration applicationConfiguration;

   private String configNodeName;

   private HandlerManager eventBus;

   public DefaultApplicationConfigurationUnmarshaler(HandlerManager eventBus, ApplicationConfiguration configuration,
      String configNodeName)
   {
      this.eventBus = eventBus;
      this.applicationConfiguration = configuration;
      this.configNodeName = configNodeName;
   }

   /**
    * {@inheritDoc}
    * @throws XMLNodeNotFoundException 
    */
   public void unmarshal(Response response)
   {
      try
      {
         Document registryDocument = XMLParser.parse(response.getText());
         XMLParser.removeWhitespace(registryDocument);

         try
         {
            if (configNodeName != null)
            {
               String jsonString = XMLFinder.findTextElement(registryDocument, configNodeName);
               this.applicationConfiguration.setConfiguration(JSONParser.parse(jsonString).isObject());
            }
            else
            {
               String jsonString =
                  XMLFinder.findTextElement(registryDocument, this.applicationConfiguration.getAppName());
               this.applicationConfiguration.setConfiguration(JSONParser.parse(jsonString).isObject());
            }
         }
         catch (XMLNodeNotFoundException e)
         {
            e.printStackTrace();
         }

      }
      catch (Exception exc)
      {
         eventBus.fireEvent(new ApplicationConfigurationReceivedFailedEvent());
      }
   }

}
