/**
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 *
 */
package org.exoplatform.gwtframework.ui.client.testcase.cases;

import org.exoplatform.gwtframework.ui.client.testcase.TestCase;
import org.exoplatform.gwtframework.ui.client.tree.Tree;
import org.exoplatform.gwtframework.ui.client.tree.TreeNode;
import org.exoplatform.gwtframework.ui.client.tree.TreeRecord;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.TextBox;

/**
 * Created by The eXo Platform SAS .
 * 
 * @author <a href="mailto:gavrikvetal@gmail.com">Vitaliy Gulyy</a>
 * @version $
 */

public class TreeAddDeleteShowcase extends TestCase
{

   private FlowPanel panel;

   private Grid grid;

   private TestTree tree;

   @Override
   public void draw()
   {
      panel = new FlowPanel();
      DOM.setStyleAttribute(panel.getElement(), "width", "100%");
      DOM.setStyleAttribute(panel.getElement(), "height", "100%");
      DOM.setStyleAttribute(panel.getElement(), "background", "#EFEFEF");
      testCasePanel().add(panel);

      grid = new Grid(2, 1);
      grid.setWidth("100%");
      grid.setHeight("100%");
      grid.setBorderWidth(0);
      panel.add(grid);

      createControlButtons();

      tree = new TestTree();
      tree.setWidth("300px");
      tree.setHeight("400px");
      grid.setWidget(1, 0, tree);

      tree.setEmptyMessage("No items present");

      DOM.setStyleAttribute(grid.getRowFormatter().getElement(1), "verticalAlign", "top");
   }

   private TextBox nodeNameTextBox;

   private Button createRootButton;

   private Button deleteRootButton;

   private Button addFolderButton;

   private Button addFileButton;

   private Button deleteItemButton;

   private void createControlButtons()
   {
      FlexTable table = new FlexTable();
      table.setWidth("100%");
      table.setHeight("80px");
      //DOM.setStyleAttribute(table.getElement(), "background", "#77FFAA");

      grid.setWidget(0, 0, table);

      DOM.setStyleAttribute(grid.getCellFormatter().getElement(0, 0), "height", "60px");

      int pos = 0;

      createRootButton = new Button("<font size=2>Create Root</font>");
      createRootButton.setSize("100px", "25px");
      createRootButton.addClickHandler(new ClickHandler()
      {
         public void onClick(ClickEvent arg0)
         {
            createRootNode();
         }
      });

      deleteRootButton = new Button("<font size=2>Delete Root</font>");
      deleteRootButton.setEnabled(false);
      deleteRootButton.setSize("100px", "25px");
      deleteRootButton.addClickHandler(new ClickHandler()
      {
         public void onClick(ClickEvent arg0)
         {
            deleteRootNode();
         }
      });

      FlowPanel rootmanagePanel = new FlowPanel();
      rootmanagePanel.add(createRootButton);
      rootmanagePanel.add(deleteRootButton);
      table.setWidget(0, pos, rootmanagePanel);
      pos++;

      nodeNameTextBox = new TextBox();
      nodeNameTextBox.setWidth("100px");
      table.setWidget(0, pos, nodeNameTextBox);
      pos++;

      FlowPanel createPanel = new FlowPanel();

      addFolderButton = new Button("<font size=2>Add Folder</font>");
      addFolderButton.setEnabled(false);
      addFolderButton.setSize("100px", "25px");
      createPanel.add(addFolderButton);

      addFolderButton.addClickHandler(new ClickHandler()
      {
         public void onClick(ClickEvent arg0)
         {
            addFolder();
         }
      });

      addFileButton = new Button("<font size=2>Add File</font>");
      addFileButton.setEnabled(false);
      addFileButton.setSize("100px", "25px");
      createPanel.add(addFileButton);

      addFileButton.addClickHandler(new ClickHandler()
      {
         public void onClick(ClickEvent arg0)
         {
            addFile();
         }
      });

      table.setWidget(0, pos, createPanel);
      pos++;

      deleteItemButton = new Button("<font size=2>Delete</font>");
      deleteItemButton.setEnabled(false);
      deleteItemButton.setSize("100px", "25px");
      table.setWidget(0, pos, deleteItemButton);
      pos++;

      deleteItemButton.addClickHandler(new ClickHandler()
      {
         public void onClick(ClickEvent arg0)
         {
            deleteNode();
         }
      });

      table.setHTML(0, pos, "&nbsp;");

      //DOM.setStyleAttribute(table.getCellFormatter().getElement(0, 0), "width", "155px");

      for (int i = 0; i < (pos - 1); i++)
      {
         DOM.setStyleAttribute(table.getCellFormatter().getElement(0, i), "width", "105px");
      }

   }

   private void add(boolean isFolder)
   {
      if (tree.getSelectedRecord() == null)
      {
         return;
      }

      TreeNode newNode = new TreeNode(nodeNameTextBox.getValue());
      newNode.setIsFolder(isFolder);
      tree.getSelectedRecord().getNode().getChildren().add(newNode);

      tree.getSelectedRecord().expand(true);
   }

   private void addFolder()
   {
      add(true);
   }

   private void addFile()
   {
      add(false);
   }

   private void deleteNode()
   {
      if (tree.getSelectedRecord() == null)
      {
         return;
      }

      if (tree.getSelectedRecord().getNode() == tree.getRoot())
      {
         deleteRootNode();

      }
      else
      {
         TreeRecord parent = tree.getSelectedRecord().getParentRecord();

         tree.getSelectedRecord().removeFromParent();
         parent.getNode().getChildren().remove(tree.getSelectedRecord().getNode());

         parent.expand(true);
      }

   }

   private void createRootNode()
   {
      if (tree.getRoot() != null)
      {
         return;
      }

      if ("".equals(nodeNameTextBox.getValue().trim()))
      {
         Window.alert("Root node must have the name!");
         return;
      }

      TreeNode root = new TreeNode(nodeNameTextBox.getValue());
      tree.setRoot(root);
      createRootButton.setEnabled(false);
      deleteRootButton.setEnabled(true);
   }

   private void deleteRootNode()
   {
      tree.setRoot(null);
      deleteRootButton.setEnabled(false);
      createRootButton.setEnabled(true);

      addFolderButton.setEnabled(false);
      addFileButton.setEnabled(false);
      deleteItemButton.setEnabled(false);
   }

   private void onItemSelected()
   {
      if (tree.getSelectedRecord() == null)
      {
         return;
      }

      TreeNode node = tree.getSelectedRecord().getNode();
      if (node.isFolder())
      {
         addFolderButton.setEnabled(true);
         addFileButton.setEnabled(true);
      }
      else
      {
         addFolderButton.setEnabled(false);
         addFileButton.setEnabled(false);
      }

      deleteItemButton.setEnabled(true);
   }

   private class TestTree extends Tree
   {
      @Override
      public void onClick(TreeRecord treerecord)
      {
         onItemSelected();
      }
   }

}
