/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.dialog;

import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.version.VersionException;
import javax.portlet.PortletMode;
import org.exoplatform.ecm.resolver.JCRResourceResolver;
import org.exoplatform.ecm.webui.form.DialogFormActionListeners;
import org.exoplatform.ecm.webui.form.UIDialogForm;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.ecm.webui.tree.selectone.UIOneTaxonomySelector;
import org.exoplatform.ecm.webui.utils.DialogFormUtil;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.CmsService;
import org.exoplatform.services.cms.JcrInputProperty;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.impl.DMSRepositoryConfiguration;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.ecm.publication.PublicationPlugin;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.dialog.UIContentDialogPreference;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputBase;
import org.exoplatform.webui.form.UIFormMultiValueInputSet;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, events={@EventConfig(listeners={AddActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveReferenceActionListener.class}, confirm="DialogFormField.msg.confirm-delete", phase=Event.Phase.DECODE), @EventConfig(listeners={SaveDraftActionListener.class}), @EventConfig(listeners={FastPublishActionListener.class}), @EventConfig(listeners={PreferencesActionListener.class}), @EventConfig(listeners={CloseActionListener.class}), @EventConfig(listeners={DialogFormActionListeners.RemoveDataActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={DialogFormActionListeners.ChangeTabActionListener.class}, phase=Event.Phase.DECODE)})
public class UIContentDialogForm
extends UIDialogForm
implements UIPopupComponent,
UISelectable {
    public static final String CONTENT_DIALOG_FORM_POPUP_WINDOW = "UIContentDialogFormPopupWindow";
    public static final String FIELD_TAXONOMY = "categories";
    public static final String TAXONOMY_CONTENT_POPUP_WINDOW = "UIContentPopupWindow";
    private NodeLocation webcontentNodeLocation;
    private List<String> listTaxonomy = new ArrayList<String>();
    private List<String> listTaxonomyName = new ArrayList<String>();
    private String template;
    private Class<? extends UIContentDialogPreference> preferenceComponent;

    @Override
    public List<String> getListTaxonomy() {
        return this.listTaxonomy;
    }

    public List<String> getlistTaxonomyName() {
        return this.listTaxonomyName;
    }

    @Override
    public void setListTaxonomy(List<String> listTaxonomyNew) {
        this.listTaxonomy = listTaxonomyNew;
    }

    public void setListTaxonomyName(List<String> listTaxonomyNameNew) {
        this.listTaxonomyName = listTaxonomyNameNew;
    }

    public NodeLocation getWebcontentNodeLocation() {
        return this.webcontentNodeLocation;
    }

    public void setWebcontentNodeLocation(NodeLocation webcontentNodeLocation) {
        this.webcontentNodeLocation = webcontentNodeLocation;
    }

    public Class<? extends UIContentDialogPreference> getPreferenceComponent() {
        return this.preferenceComponent;
    }

    public void setPreferenceComponent(Class<? extends UIContentDialogPreference> preferenceComponent) {
        this.preferenceComponent = preferenceComponent;
    }

    public UIContentDialogForm() throws Exception {
        this.setActions(new String[]{"SaveDraft", "FastPublish", "Preferences", "Close"});
    }

    public void init(Node webcontent, boolean isAddNew) throws Exception {
        NodeLocation webcontentNodeLocation = null;
        if (webcontent.isNodeType("exo:symlink")) {
            LinkManager linkManager = (LinkManager)this.getApplicationComponent(LinkManager.class);
            Node realNode = linkManager.getTarget(webcontent);
            webcontentNodeLocation = NodeLocation.getNodeLocationByNode((Node)realNode);
            this.contentType = realNode.getPrimaryNodeType().getName();
            this.nodePath = realNode.getPath();
            this.setStoredPath(this.getParentPath(realNode));
        } else {
            webcontentNodeLocation = NodeLocation.getNodeLocationByNode((Node)webcontent);
            this.contentType = webcontent.getPrimaryNodeType().getName();
            this.nodePath = webcontent.getPath();
            this.setStoredPath(this.getParentPath(webcontent));
        }
        this.webcontentNodeLocation = webcontentNodeLocation;
        this.repositoryName = webcontentNodeLocation.getRepository();
        this.workspaceName = webcontentNodeLocation.getWorkspace();
        this.isAddNew = isAddNew;
        this.resetProperties();
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        String userName = Util.getPortalRequestContext().getRemoteUser();
        this.template = templateService.getTemplatePathByUser(true, this.contentType, userName);
        this.initFieldInput();
    }

    private String getParentPath(Node node) throws RepositoryException {
        return node.getPath().substring(0, node.getPath().lastIndexOf(47));
    }

    private void initFieldInput() throws Exception {
        TemplateService tservice = (TemplateService)this.getApplicationComponent(TemplateService.class);
        List documentNodeType = tservice.getDocumentTemplates();
        if (!documentNodeType.contains(this.contentType)) {
            return;
        }
        if (!this.isAddNew) {
            TaxonomyService taxonomyService = (TaxonomyService)this.getApplicationComponent(TaxonomyService.class);
            Node currentNode = this.getCurrentNode();
            List listCategories = taxonomyService.getAllCategories(currentNode);
            for (Node itemNode : listCategories) {
                String categoryPath = itemNode.getPath().replaceAll(this.getPathTaxonomy() + "/", "");
                if (this.listTaxonomy.contains(categoryPath)) continue;
                this.listTaxonomy.add(categoryPath);
                this.listTaxonomyName.add(categoryPath);
            }
        }
        if (this.listTaxonomyName == null || this.listTaxonomyName.size() == 0) {
            return;
        }
        UIFormMultiValueInputSet uiFormMultiValue = (UIFormMultiValueInputSet)this.createUIComponent(UIFormMultiValueInputSet.class, null, null);
        uiFormMultiValue.setId(FIELD_TAXONOMY);
        uiFormMultiValue.setName(FIELD_TAXONOMY);
        uiFormMultiValue.setType(UIFormStringInput.class);
        uiFormMultiValue.setValue(this.listTaxonomyName);
        this.addUIFormInput((UIFormInput)uiFormMultiValue);
    }

    public Node getCurrentNode() {
        return NodeLocation.getNodeByLocation((NodeLocation)this.webcontentNodeLocation);
    }

    @Override
    public String getTemplate() {
        return this.template;
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        DMSConfiguration dmsConfiguration = (DMSConfiguration)this.getApplicationComponent(DMSConfiguration.class);
        String workspace = dmsConfiguration.getConfig().getSystemWorkspace();
        return new JCRResourceResolver(workspace);
    }

    private boolean checkCategories(UIContentDialogForm contentDialogForm) {
        UIFormMultiValueInputSet uiSet;
        String categoriesPath = "";
        String[] categoriesPathList = null;
        int index = 0;
        if (contentDialogForm.isReference && (uiSet = (UIFormMultiValueInputSet)contentDialogForm.getChild(UIFormMultiValueInputSet.class)) != null && uiSet.getName() != null && uiSet.getName().equals(FIELD_TAXONOMY)) {
            List listChildren = uiSet.getChildren();
            for (UIComponent component : listChildren) {
                UIFormStringInput uiStringInput = (UIFormStringInput)component;
                if (uiStringInput.getValue() == null) continue;
                String value = ((String)uiStringInput.getValue()).trim();
                categoriesPath = categoriesPath + value + ",";
            }
            if (categoriesPath != null && categoriesPath.length() > 0) {
                try {
                    if (categoriesPath.endsWith(",") && (categoriesPath = categoriesPath.substring(0, categoriesPath.length() - 1).trim()).trim().length() == 0) {
                        return true;
                    }
                    categoriesPathList = categoriesPath.split(",");
                    if (categoriesPathList == null || categoriesPathList.length == 0) {
                        return true;
                    }
                    for (String categoryPath : categoriesPathList) {
                        index = categoryPath.indexOf("/");
                        if (index >= 0) continue;
                        return true;
                    }
                }
                catch (Exception e) {
                    return true;
                }
            }
        }
        return false;
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    @Override
    public void doSelect(String selectField, Object value) throws Exception {
        this.isUpdateSelect = true;
        UIFormInput formInput = this.getUIInput(selectField);
        if (formInput instanceof UIFormInputBase) {
            ((UIFormInputBase)formInput).setValue((Object)value.toString());
        } else if (formInput instanceof UIFormMultiValueInputSet) {
            UIFormMultiValueInputSet inputSet = (UIFormMultiValueInputSet)formInput;
            String valueTaxonomy = String.valueOf(value).trim();
            List taxonomylist = inputSet.getValue();
            if (!taxonomylist.contains(valueTaxonomy)) {
                this.listTaxonomy.add(valueTaxonomy);
                this.listTaxonomyName.add(valueTaxonomy);
                taxonomylist.add(valueTaxonomy);
            }
            inputSet.setValue(taxonomylist);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveReferenceActionListener
    extends EventListener<UIContentDialogForm> {
        public void execute(Event<UIContentDialogForm> event) throws Exception {
            UIContentDialogForm contentDialogForm = (UIContentDialogForm)event.getSource();
            contentDialogForm.isRemovePreference = true;
            String fieldName = event.getRequestContext().getRequestParameter("objectId");
            contentDialogForm.getUIStringInput(fieldName).setValue(null);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)contentDialogForm);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddActionListener
    extends EventListener<UIContentDialogForm> {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void execute(Event<UIContentDialogForm> event) throws Exception {
            UIContentDialogForm contentDialogForm = (UIContentDialogForm)event.getSource();
            String clickedField = event.getRequestContext().getRequestParameter("objectId");
            if (contentDialogForm.isReference) {
                UIApplication uiApp = (UIApplication)contentDialogForm.getAncestorOfType(UIApplication.class);
                try {
                    UIFormMultiValueInputSet uiSet = (UIFormMultiValueInputSet)contentDialogForm.getChildById(UIContentDialogForm.FIELD_TAXONOMY);
                    if (uiSet == null || uiSet.getName() == null || !uiSet.getName().equals(UIContentDialogForm.FIELD_TAXONOMY) || clickedField == null || !clickedField.equals(UIContentDialogForm.FIELD_TAXONOMY)) return;
                    NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)contentDialogForm.getApplicationComponent(NodeHierarchyCreator.class);
                    String repository = contentDialogForm.repositoryName;
                    DMSConfiguration dmsConfiguration = (DMSConfiguration)contentDialogForm.getApplicationComponent(DMSConfiguration.class);
                    DMSRepositoryConfiguration repositoryConfiguration = dmsConfiguration.getConfig();
                    String workspaceName = repositoryConfiguration.getSystemWorkspace();
                    UIOneTaxonomySelector uiOneTaxonomySelector = (UIOneTaxonomySelector)contentDialogForm.createUIComponent(UIOneTaxonomySelector.class, null, null);
                    if (uiSet.getValue().size() == 0) {
                        uiSet.setValue(new ArrayList());
                    }
                    String rootTreePath = nodeHierarchyCreator.getJcrPath("exoTaxoTreesStoragePath");
                    RepositoryService repositoryService = (RepositoryService)contentDialogForm.getApplicationComponent(RepositoryService.class);
                    ManageableRepository manageableRepository = repositoryService.getCurrentRepository();
                    Session session = WCMCoreUtils.getUserSessionProvider().getSession(workspaceName, manageableRepository);
                    Node rootTree = (Node)session.getItem(rootTreePath);
                    NodeIterator childrenIterator = rootTree.getNodes();
                    if (childrenIterator.hasNext()) {
                        Node childNode = childrenIterator.nextNode();
                        rootTreePath = childNode.getPath();
                    }
                    uiOneTaxonomySelector.setRootNodeLocation(repository, workspaceName, rootTreePath);
                    uiOneTaxonomySelector.setExceptedNodeTypesInPathPanel(new String[]{"exo:symlink"});
                    uiOneTaxonomySelector.init(WCMCoreUtils.getUserSessionProvider());
                    String param = "returnField=categories";
                    uiOneTaxonomySelector.setSourceComponent((UIComponent)contentDialogForm, new String[]{param});
                    Utils.createPopupWindow((UIContainer)contentDialogForm, (UIComponent)uiOneTaxonomySelector, UIContentDialogForm.TAXONOMY_CONTENT_POPUP_WINDOW, 700);
                    return;
                }
                catch (AccessDeniedException accessDeniedException) {
                    uiApp.addMessage(new ApplicationMessage("UIContentDialogForm.msg.access-denied", null, 1));
                    return;
                }
                catch (Exception e) {
                    uiApp.addMessage(new ApplicationMessage("UIContentDialogForm.msg.exception", null, 1));
                    return;
                }
            } else {
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)contentDialogForm);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FastPublishActionListener
    extends EventListener<UIContentDialogForm> {
        public void execute(Event<UIContentDialogForm> event) throws Exception {
            UIContentDialogForm contentDialogForm = (UIContentDialogForm)event.getSource();
            try {
                Node webContentNode = contentDialogForm.getNode();
                if (!webContentNode.isCheckedOut()) {
                    webContentNode.checkout();
                }
                List inputs = contentDialogForm.getChildren();
                if (contentDialogForm.checkCategories(contentDialogForm)) {
                    Utils.createPopupMessage((UIContainer)contentDialogForm, "UIContentDialogForm.msg.non-categories", null, 1);
                    return;
                }
                Map<String, JcrInputProperty> inputProperties = DialogFormUtil.prepareMap(inputs, contentDialogForm.getInputProperties());
                CmsService cmsService = (CmsService)contentDialogForm.getApplicationComponent(CmsService.class);
                cmsService.storeNode(contentDialogForm.contentType, contentDialogForm.getNode().getParent(), inputProperties, contentDialogForm.isAddNew);
                PublicationService publicationService = (PublicationService)contentDialogForm.getApplicationComponent(PublicationService.class);
                PublicationPlugin publicationPlugin = (PublicationPlugin)publicationService.getPublicationPlugins().get(publicationService.getNodeLifecycleName(webContentNode));
                HashMap<String, String> context = new HashMap<String, String>();
                if (webContentNode != null) {
                    context.put("Publication.context.currentVersion", webContentNode.getName());
                }
                publicationPlugin.changeState(webContentNode, "published", context);
                if (Util.getUIPortalApplication().getModeState() == 0) {
                    ((PortletRequestContext)event.getRequestContext()).setApplicationMode(PortletMode.VIEW);
                }
                Utils.closePopupWindow((UIContainer)contentDialogForm, UIContentDialogForm.CONTENT_DIALOG_FORM_POPUP_WINDOW);
            }
            catch (LockException le) {
                Object[] args = new Object[]{contentDialogForm.getNode().getPath()};
                Utils.createPopupMessage((UIContainer)contentDialogForm, "UIContentDialogForm.msg.node-locked", args, 1);
            }
            catch (AccessControlException ace) {
            }
            catch (AccessDeniedException ade) {
                Utils.createPopupMessage((UIContainer)contentDialogForm, "UIDocumentInfo.msg.access-denied-exception", null, 1);
            }
            catch (VersionException ve) {
                Utils.createPopupMessage((UIContainer)contentDialogForm, "UIDocumentForm.msg.in-versioning", null, 1);
            }
            catch (ItemNotFoundException item) {
                Utils.createPopupMessage((UIContainer)contentDialogForm, "UIDocumentForm.msg.item-not-found", null, 1);
            }
            catch (RepositoryException repo) {
                String key = "UIDocumentForm.msg.repository-exception";
                if (ItemExistsException.class.isInstance((Object)repo)) {
                    key = "UIDocumentForm.msg.not-allowed-same-name-sibling";
                }
                Utils.createPopupMessage((UIContainer)contentDialogForm, key, null, 1);
            }
            catch (NumberFormatException nfe) {
                Utils.createPopupMessage((UIContainer)contentDialogForm, "UIDocumentForm.msg.numberformat-exception", null, 1);
            }
            catch (Exception e) {
                Utils.createPopupMessage((UIContainer)contentDialogForm, "UIDocumentForm.msg.cannot-save", null, 1);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveDraftActionListener
    extends EventListener<UIContentDialogForm> {
        public void execute(Event<UIContentDialogForm> event) throws Exception {
            UIContentDialogForm contentDialogForm = (UIContentDialogForm)event.getSource();
            try {
                Node webContentNode = contentDialogForm.getNode();
                if (!webContentNode.isCheckedOut()) {
                    webContentNode.checkout();
                }
                List inputs = contentDialogForm.getChildren();
                if (contentDialogForm.checkCategories(contentDialogForm)) {
                    Utils.createPopupMessage((UIContainer)contentDialogForm, "UIContentDialogForm.msg.non-categories", null, 1);
                    return;
                }
                Map<String, JcrInputProperty> inputProperties = DialogFormUtil.prepareMap(inputs, contentDialogForm.getInputProperties());
                CmsService cmsService = (CmsService)contentDialogForm.getApplicationComponent(CmsService.class);
                if (this.canAccessParentNode(webContentNode)) {
                    cmsService.storeNode(contentDialogForm.contentType, webContentNode.getParent(), inputProperties, contentDialogForm.isAddNew);
                } else {
                    cmsService.storeEditedNode(contentDialogForm.contentType, webContentNode, inputProperties, contentDialogForm.isAddNew);
                }
                if (Util.getUIPortalApplication().getModeState() == 0) {
                    ((PortletRequestContext)event.getRequestContext()).setApplicationMode(PortletMode.VIEW);
                }
                Utils.closePopupWindow((UIContainer)contentDialogForm, UIContentDialogForm.CONTENT_DIALOG_FORM_POPUP_WINDOW);
            }
            catch (LockException le) {
                Object[] args = new Object[]{contentDialogForm.getNode().getPath()};
                Utils.createPopupMessage((UIContainer)contentDialogForm, "UIContentDialogForm.msg.node-locked", args, 1);
            }
            catch (AccessControlException ace) {
            }
            catch (AccessDeniedException ade) {
                Utils.createPopupMessage((UIContainer)contentDialogForm, "UIDocumentInfo.msg.access-denied-exception", null, 1);
            }
            catch (VersionException ve) {
                Utils.createPopupMessage((UIContainer)contentDialogForm, "UIDocumentForm.msg.in-versioning", null, 1);
            }
            catch (ItemNotFoundException item) {
                Utils.createPopupMessage((UIContainer)contentDialogForm, "UIDocumentForm.msg.item-not-found", null, 1);
            }
            catch (RepositoryException repo) {
                String key = "UIDocumentForm.msg.repository-exception";
                if (ItemExistsException.class.isInstance((Object)repo)) {
                    key = "UIDocumentForm.msg.not-allowed-same-name-sibling";
                }
                Utils.createPopupMessage((UIContainer)contentDialogForm, key, null, 1);
            }
            catch (NumberFormatException nfe) {
                Utils.createPopupMessage((UIContainer)contentDialogForm, "UIDocumentForm.msg.numberformat-exception", null, 1);
            }
            catch (Exception e) {
                Utils.createPopupMessage((UIContainer)contentDialogForm, "UIDocumentForm.msg.cannot-save", null, 1);
            }
        }

        private boolean canAccessParentNode(Node node) {
            try {
                node.getParent();
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PreferencesActionListener
    extends EventListener<UIContentDialogForm> {
        public void execute(Event<UIContentDialogForm> event) throws Exception {
            UIContentDialogForm contentDialogForm = (UIContentDialogForm)event.getSource();
            UIPopupContainer popupContainer = Utils.getPopupContainer((UIContainer)contentDialogForm);
            popupContainer.addChild((UIComponent)contentDialogForm);
            contentDialogForm.setParent((UIComponent)popupContainer);
            UIContentDialogPreference contentDialogPreference = null;
            contentDialogPreference = contentDialogForm.getPreferenceComponent() != null ? (UIContentDialogPreference)contentDialogForm.createUIComponent(contentDialogForm.getPreferenceComponent(), null, null) : (UIContentDialogPreference)contentDialogForm.createUIComponent(UIContentDialogPreference.class, null, null);
            Utils.updatePopupWindow((UIContainer)contentDialogForm, (UIComponent)contentDialogPreference, UIContentDialogForm.CONTENT_DIALOG_FORM_POPUP_WINDOW);
            contentDialogPreference.init();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CloseActionListener
    extends EventListener<UIContentDialogForm> {
        public void execute(Event<UIContentDialogForm> event) throws Exception {
            UIContentDialogForm contentDialogForm = (UIContentDialogForm)event.getSource();
            if (Util.getUIPortalApplication().getModeState() == 0) {
                ((PortletRequestContext)event.getRequestContext()).setApplicationMode(PortletMode.VIEW);
            }
            Utils.closePopupWindow((UIContainer)contentDialogForm, UIContentDialogForm.CONTENT_DIALOG_FORM_POPUP_WINDOW);
        }
    }
}

