/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webservice.cs.calendar;

import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.SyndFeedOutput;
import com.sun.syndication.io.XmlReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import javax.annotation.security.RolesAllowed;
import javax.jcr.PathNotFoundException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarImportExport;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.calendar.service.EventPageList;
import org.exoplatform.calendar.service.EventQuery;
import org.exoplatform.calendar.service.FeedData;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.webservice.cs.bean.EventData;
import org.exoplatform.webservice.cs.bean.SingleEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/cs/calendar")
public class CalendarWebservice
implements ResourceContainer {
    public static final String BASE_URL = "/cs/calendar".intern();
    public static final String BASE_RSS_URL = BASE_URL + "/feed".intern();
    public static final String BASE_EVENT_URL = BASE_URL + "/event".intern();
    public static final String BASE_URL_PUBLIC = "/cs/calendar/subscribe/".intern();
    public static final String BASE_URL_PRIVATE = BASE_URL + "/".intern();
    private Log log = ExoLogger.getExoLogger((String)"calendar.webservice");

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/checkPermission/{username}/{calendarId}/{type}/")
    public Response checkPermission(@PathParam(value="username") String username, @PathParam(value="calendarId") String calendarId, @PathParam(value="type") String type) throws Exception {
        EventData eventData = new EventData();
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        try {
            CalendarService calService = (CalendarService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(CalendarService.class);
            Calendar cal = null;
            eventData.setPermission(false);
            if (0 == Integer.parseInt(type)) {
                if (calService.isRemoteCalendar(username, calendarId)) {
                    eventData.setPermission(false);
                } else {
                    eventData.setPermission(true);
                }
            } else if (2 == Integer.parseInt(type)) {
                OrganizationService oService = (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class);
                if (Utils.canEdit((OrganizationService)oService, (String[])(cal = calService.getGroupCalendar(calendarId)).getEditPermission(), (String)username)) {
                    eventData.setPermission(true);
                }
            } else if (1 == Integer.parseInt(type) && calService.getSharedCalendars(username, true) != null && Utils.canEdit(null, (String[])Utils.getEditPerUsers((Calendar)(cal = calService.getSharedCalendars(username, true).getCalendarById(calendarId))), (String)username)) {
                eventData.setPermission(true);
            }
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Exception when check permission", (Throwable)e);
            }
            eventData.setPermission(false);
        }
        return Response.ok((Object)eventData, (String)"application/json").cacheControl(cacheControl).build();
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/event/{username}/{eventFeedName}/")
    public Response event(@PathParam(value="username") String username, @PathParam(value="eventFeedName") String eventFeedName) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        try {
            EventQuery eventQuery;
            if (!this.isAuthorized(username)) {
                return Response.status((int)423).entity((Object)"Unauthorized: Access is denied").cacheControl(cacheControl).build();
            }
            CalendarService calService = (CalendarService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(CalendarService.class);
            CalendarImportExport icalEx = calService.getCalendarImportExports(CalendarService.ICALENDAR);
            String eventId = eventFeedName.split("splitter")[0];
            String type = eventFeedName.split("splitter")[1].replace(Utils.ICS_EXT, "");
            CalendarEvent event = null;
            if (type.equals("0")) {
                event = calService.getEvent(username, eventId);
            } else if (type.equals("1")) {
                eventQuery = new EventQuery();
                eventQuery.setText(eventId);
                event = (CalendarEvent)calService.getEvents(username, eventQuery, null).get(0);
            } else {
                eventQuery = new EventQuery();
                eventQuery.setText(eventId);
                event = (CalendarEvent)calService.getPublicEvents(eventQuery).get(0);
            }
            if (event == null) {
                return Response.status((int)404).entity((Object)("Event " + eventId + "is removed")).cacheControl(cacheControl).build();
            }
            ByteArrayOutputStream out = icalEx.exportEventCalendar(event);
            ByteArrayInputStream in = new ByteArrayInputStream(((Object)out).toString().getBytes());
            return Response.ok((Object)in, (String)"text/calendar").header("Cache-Control", (Object)"private max-age=600, s-maxage=120").header("Content-Disposition", (Object)("attachment;filename=\"" + eventId + Utils.ICS_EXT)).cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)e.getMessage());
            }
            return Response.status((int)500).entity((Object)e).cacheControl(cacheControl).build();
        }
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/feed/{username}/{feedname}/{filename}/")
    public Response feed(@PathParam(value="username") String username, @PathParam(value="feedname") String feedname, @PathParam(value="filename") String filename) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        try {
            if (!this.isAuthorized(username)) {
                return Response.status((int)423).entity((Object)"Unauthorized: Access is denied").cacheControl(cacheControl).build();
            }
            CalendarService calService = (CalendarService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(CalendarService.class);
            FeedData feed = null;
            for (FeedData feedData : calService.getFeeds(username)) {
                if (!feedData.getTitle().equals(feedname)) continue;
                feed = feedData;
                break;
            }
            SyndFeedInput input = new SyndFeedInput();
            SyndFeed syndFeed = input.build((Reader)new XmlReader((InputStream)new ByteArrayInputStream(feed.getContent())));
            ArrayList entries = new ArrayList(syndFeed.getEntries());
            ArrayList<CalendarEvent> events = new ArrayList<CalendarEvent>();
            for (SyndEntry entry : entries) {
                String calendarId = entry.getLink().substring(entry.getLink().lastIndexOf("/") + 1);
                ArrayList<String> calendarIds = new ArrayList<String>();
                calendarIds.add(calendarId);
                Calendar calendar = calService.getUserCalendar(username, calendarId);
                if (calendar != null) {
                    events.addAll(calService.getUserEventByCalendar(username, calendarIds));
                    continue;
                }
                try {
                    calendar = calService.getSharedCalendars(username, false).getCalendarById(calendarId);
                }
                catch (NullPointerException e) {
                    calendar = null;
                }
                if (calendar != null) {
                    events.addAll(calService.getSharedEventByCalendars(username, calendarIds));
                    continue;
                }
                calendar = calService.getGroupCalendar(calendarId);
                if (calendar == null) continue;
                EventQuery eventQuery = new EventQuery();
                eventQuery.setCalendarId(calendarIds.toArray(new String[0]));
                events.addAll(calService.getPublicEvents(eventQuery));
            }
            if (events.size() == 0) {
                return Response.status((int)404).entity((Object)("Feed " + feedname + "is removed")).cacheControl(cacheControl).build();
            }
            return Response.ok((Object)this.makeFeed(username, events, feed), (String)"application/xml").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)e.getMessage());
            }
            return Response.status((int)500).entity((Object)e).cacheControl(cacheControl).build();
        }
    }

    private String makeFeed(String author, List<CalendarEvent> events, FeedData feedData) throws Exception {
        String baseURL = feedData.getUrl().split(BASE_RSS_URL)[0];
        SyndFeedImpl feed = new SyndFeedImpl();
        feed.setFeedType("rss_2.0");
        feed.setTitle(feedData.getTitle());
        feed.setLink(feedData.getUrl());
        feed.setDescription(feedData.getTitle());
        ArrayList<SyndEntryImpl> entries = new ArrayList<SyndEntryImpl>();
        for (CalendarEvent event : events) {
            if (Utils.EVENT_NUMBER > 0 && Utils.EVENT_NUMBER <= entries.size()) break;
            SyndEntryImpl entry = new SyndEntryImpl();
            entry.setTitle(event.getSummary());
            entry.setLink(baseURL + BASE_EVENT_URL + Utils.SLASH + author + Utils.SLASH + event.getId() + "splitter" + event.getCalType() + Utils.ICS_EXT);
            entry.setAuthor(author);
            SyndContentImpl description = new SyndContentImpl();
            description.setType(Utils.MIMETYPE_TEXTPLAIN);
            description.setValue(event.getDescription());
            entry.setDescription((SyndContent)description);
            entries.add(entry);
            entry.getEnclosures();
        }
        feed.setEntries(entries);
        feed.setEncoding("UTF-8");
        SyndFeedOutput output = new SyndFeedOutput();
        String feedXML = output.outputString((SyndFeed)feed);
        feedXML = StringUtils.replace((String)feedXML, (String)"&amp;", (String)"&");
        return feedXML;
    }

    @GET
    @Path(value="/subscribe/{username}/{calendarId}/{type}")
    public Response publicProcess(@PathParam(value="username") String username, @PathParam(value="calendarId") String calendarId, @PathParam(value="type") String type) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        try {
            CalendarService calService = (CalendarService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(CalendarService.class);
            Calendar calendar = null;
            if (type.equals("0")) {
                calendar = calService.getUserCalendar(username, calendarId);
            } else if (type.equals("1")) {
                try {
                    calendar = calService.getSharedCalendars(username, false).getCalendarById(calendarId);
                }
                catch (NullPointerException ex) {}
            } else {
                try {
                    calendar = calService.getGroupCalendar(calendarId);
                }
                catch (PathNotFoundException ex) {
                    // empty catch block
                }
            }
            if (calendar == null || Utils.isEmpty((String)calendar.getPublicUrl())) {
                return Response.status((int)423).entity((Object)("Calendar " + calendarId + " is not public access")).cacheControl(cacheControl).build();
            }
            CalendarImportExport icalEx = calService.getCalendarImportExports(CalendarService.ICALENDAR);
            OutputStream out = icalEx.exportCalendar(username, Arrays.asList(calendarId), type, -1);
            ByteArrayInputStream in = new ByteArrayInputStream(out.toString().getBytes());
            return Response.ok((Object)in, (String)"text/calendar").header("Cache-Control", (Object)"private max-age=600, s-maxage=120").header("Content-Disposition", (Object)("attachment;filename=\"" + calendarId + ".ics")).cacheControl(cacheControl).build();
        }
        catch (NullPointerException ne) {
            return Response.ok(null, (String)"text/calendar").header("Cache-Control", (Object)"private max-age=600, s-maxage=120").header("Content-Disposition", (Object)("attachment;filename=\"" + calendarId + ".ics")).cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)e.getMessage());
            }
            return Response.status((int)500).entity((Object)e).cacheControl(cacheControl).build();
        }
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/{username}/{calendarId}/{type}")
    public Response privateProcess(@PathParam(value="username") String username, @PathParam(value="calendarId") String calendarId, @PathParam(value="type") String type) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        try {
            if (!this.isAuthorized(username)) {
                return Response.status((int)423).entity((Object)"Unauthorized: Access is denied").cacheControl(cacheControl).build();
            }
            CalendarService calService = (CalendarService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(CalendarService.class);
            CalendarImportExport icalEx = calService.getCalendarImportExports(CalendarService.ICALENDAR);
            OutputStream out = icalEx.exportCalendar(username, Arrays.asList(calendarId), type, -1);
            ByteArrayInputStream in = new ByteArrayInputStream(out.toString().getBytes());
            return Response.ok((Object)in, (String)"text/calendar").header("Cache-Control", (Object)"private max-age=600, s-maxage=120").header("Content-Disposition", (Object)("attachment;filename=\"" + calendarId + ".ics")).cacheControl(cacheControl).build();
        }
        catch (NullPointerException ne) {
            return Response.ok(null, (String)"text/calendar").header("Cache-Control", (Object)"private max-age=600, s-maxage=120").header("Content-Disposition", (Object)("attachment;filename=\"" + calendarId + ".ics")).cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)e.getMessage());
            }
            return Response.status((int)500).entity((Object)e).cacheControl(cacheControl).build();
        }
    }

    private boolean isAuthorized(String usename) {
        return ConversationState.getCurrent() != null && ConversationState.getCurrent().getIdentity() != null && ConversationState.getCurrent().getIdentity().getUserId() != null && ConversationState.getCurrent().getIdentity().getUserId().equals(usename);
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/getissues/{currentdatetime}/{type}/{limit}")
    public Response upcomingEvent(@PathParam(value="currentdatetime") String currentdatetime, @PathParam(value="type") String type, @PathParam(value="limit") int limit) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        try {
            if (!CalendarEvent.TYPE_EVENT.equalsIgnoreCase(type) && !CalendarEvent.TYPE_TASK.equalsIgnoreCase(type)) {
                return Response.status((int)400).cacheControl(cacheControl).build();
            }
            SimpleDateFormat sf = new SimpleDateFormat("yyyyMMdd");
            java.util.Calendar fromCal = GregorianCalendar.getInstance();
            java.util.Calendar toCal = GregorianCalendar.getInstance();
            fromCal.setTime(sf.parse(currentdatetime));
            toCal.setTime(sf.parse(currentdatetime));
            CalendarService calService = (CalendarService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(CalendarService.class);
            EventQuery eventQuery = new EventQuery();
            eventQuery.setFromDate(fromCal);
            toCal.add(11, 24);
            eventQuery.setToDate(toCal);
            eventQuery.setLimitedItems(limit);
            eventQuery.setOrderBy(new String[]{Utils.EXO_FROM_DATE_TIME});
            String username = ConversationState.getCurrent().getIdentity().getUserId();
            eventQuery.setEventType(type);
            EventPageList data = calService.searchEvent(username, eventQuery, null);
            CalendarSetting calSetting = calService.getCalendarSetting(username);
            String timezoneId = calSetting.getTimeZone();
            TimeZone userTimezone = TimeZone.getTimeZone(timezoneId);
            int timezoneOffset = userTimezone.getRawOffset() + userTimezone.getDSTSavings();
            if (data == null || data.getAll().isEmpty()) {
                return Response.status((int)204).cacheControl(cacheControl).build();
            }
            EventData eventData = new EventData();
            eventData.setInfo(data.getAll());
            eventData.setUserTimezoneOffset(Integer.toString(timezoneOffset));
            return Response.ok((Object)eventData, (String)"application/json").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)e.getMessage());
            }
            return Response.status((int)500).cacheControl(cacheControl).build();
        }
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/updatestatus/{taskid}")
    public Response updateStatus(@PathParam(value="taskid") String taskid) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        try {
            CalendarService calService = (CalendarService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(CalendarService.class);
            String username = ConversationState.getCurrent().getIdentity().getUserId();
            CalendarEvent task = calService.getEvent(username, taskid);
            String calendarId = task.getCalendarId();
            task.setEventState(CalendarEvent.COMPLETED);
            calService.saveUserEvent(username, calendarId, task, false);
            return Response.ok((Object)"true", (String)"application/json").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            return Response.status((int)500).cacheControl(cacheControl).build();
        }
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/getcalendars")
    public Response getCalendars() throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        try {
            CalendarService calService = (CalendarService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(CalendarService.class);
            String username = ConversationState.getCurrent().getIdentity().getUserId();
            List calList = calService.getUserCalendars(username, true);
            EventData data = new EventData();
            data.setCalendars(calList);
            return Response.ok((Object)data, (String)"application/json").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            return Response.status((int)500).cacheControl(cacheControl).build();
        }
    }

    private SingleEvent makeSingleEvent(CalendarSetting calSetting, CalendarEvent cEvent) {
        if (calSetting == null || cEvent == null) {
            throw new IllegalArgumentException("parameters must be not null");
        }
        SingleEvent event = new SingleEvent();
        event.setDescription(cEvent.getDescription());
        event.setEventState(cEvent.getEventState());
        event.setLocation(cEvent.getLocation());
        event.setPriority(cEvent.getPriority());
        event.setSummary(cEvent.getSummary());
        TimeZone timeZone = TimeZone.getTimeZone(calSetting.getTimeZone());
        event.setStartDateTime(cEvent.getFromDateTime().getTime());
        event.setStartTimeOffset(timeZone.getOffset(cEvent.getFromDateTime().getTime()));
        event.setEndDateTime(cEvent.getToDateTime().getTime());
        event.setEndTimeOffset(timeZone.getOffset(cEvent.getToDateTime().getTime()));
        return event;
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/getevent/{eventid}")
    public Response getEvent(@PathParam(value="eventid") String eventid) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        try {
            CalendarService calService = (CalendarService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(CalendarService.class);
            String username = ConversationState.getCurrent().getIdentity().getUserId();
            CalendarEvent calEvent = calService.getEvent(username, eventid);
            CalendarSetting calSetting = calService.getCalendarSetting(username);
            if (!calEvent.getAttachment().isEmpty()) {
                calEvent.setAttachment(null);
            }
            SingleEvent data = this.makeSingleEvent(calSetting, calEvent);
            return Response.ok((Object)data, (String)"application/json").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            return Response.status((int)500).cacheControl(cacheControl).build();
        }
    }

    @GET
    @Path(value="/invitation/{calendarId}/{calType}/{eventId}/{inviter}/{invitee}/{eXoId}/{answer}")
    public Response processInvitationReply(@PathParam(value="calendarId") String calendarId, @PathParam(value="calType") String calType, @PathParam(value="eventId") String eventId, @PathParam(value="inviter") String inviter, @PathParam(value="invitee") String invitee, @PathParam(value="eXoId") String eXoId, @PathParam(value="answer") String answer) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        try {
            CalendarService calService = (CalendarService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(CalendarService.class);
            String userId = eXoId.equals("null") ? null : eXoId;
            calService.confirmInvitation(inviter, invitee, userId, Integer.parseInt(calType), calendarId, eventId, Integer.parseInt(answer));
            int ans = Integer.parseInt(answer);
            StringBuffer response = new StringBuffer();
            response.append("<html><head><title>Invitation Answer</title></head>");
            response.append("<body>");
            switch (ans) {
                case 1: {
                    response.append("You have accepted invitation from " + inviter);
                    break;
                }
                case 0: {
                    response.append("You have refused invitation from " + inviter);
                    break;
                }
                case 2: {
                    response.append("You have answered invitation from " + inviter + " : Not sure!");
                }
            }
            response.append("</body></html>");
            return Response.ok((Object)response.toString(), (String)"text/html").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)e.getMessage());
            }
            return Response.status((int)500).cacheControl(cacheControl).build();
        }
    }
}

