/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.migration;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Session;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeValue;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionValue;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

public class VoteNodeTypeMigrationService
implements Startable {
    private static final String VOTER_VOTEVALUE_PROP = "exo:voterVoteValues";
    private static final String MIX_VOTABLE = "mix:votable";
    private DMSConfiguration dmsConfiguration_;
    private RepositoryService repoService_;
    private Log log = ExoLogger.getLogger(this.getClass());

    public VoteNodeTypeMigrationService(RepositoryService repoService, DMSConfiguration dmsConfiguration) {
        this.repoService_ = repoService;
        this.dmsConfiguration_ = dmsConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.log.info((Object)("Start " + this.getClass().getName() + "............."));
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            Session session = sessionProvider.getSession(this.dmsConfiguration_.getConfig().getSystemWorkspace(), this.repoService_.getCurrentRepository());
            ExtendedNodeTypeManager nodeTypeManager = (ExtendedNodeTypeManager)session.getWorkspace().getNodeTypeManager();
            NodeTypeValue mixVotableNodeTypeValue = nodeTypeManager.getNodeTypeValue(MIX_VOTABLE);
            List propertyDefinitionList = mixVotableNodeTypeValue.getDeclaredPropertyDefinitionValues();
            boolean propertyExists = false;
            for (PropertyDefinitionValue propertyDefinition : propertyDefinitionList) {
                if (!propertyDefinition.getName().equals(VOTER_VOTEVALUE_PROP)) continue;
                propertyExists = true;
                break;
            }
            if (!propertyExists) {
                propertyDefinitionList.add(new PropertyDefinitionValue(VOTER_VOTEVALUE_PROP, true, false, 1, false, new ArrayList(), true, 1, new ArrayList()));
                mixVotableNodeTypeValue.setDeclaredPropertyDefinitionValues(propertyDefinitionList);
                nodeTypeManager.registerNodeType(mixVotableNodeTypeValue, 4);
            }
            this.log.info((Object)"Add new property 'exo:voterVoteValues' for node type 'mix:votable' successfully!");
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"An unexpected error occurs when add new property 'exo:voterVoteValues' for node type 'mix:votable'!", (Throwable)e);
            }
        }
        finally {
            sessionProvider.close();
        }
    }

    public void stop() {
    }
}

