/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.common.space.listeners;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.impl.DMSRepositoryConfiguration;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;

public class CustomizeSpaceDriveListener
extends SpaceListenerPlugin {
    private static final String SPACE_DRIVE_VIEW = "space.drive.view";
    private NodeHierarchyCreator nodeHierarchyCreator = null;
    private DMSConfiguration dmsConfiguration = null;
    private RepositoryService repositoryService = null;
    private String viewNodeName = null;
    private static Log logger = ExoLogger.getExoLogger(CustomizeSpaceDriveListener.class);

    public CustomizeSpaceDriveListener(NodeHierarchyCreator nodeHierarchyCreator_, DMSConfiguration dmsConfiguration_, RepositoryService repositoryService_, InitParams params) {
        this.nodeHierarchyCreator = nodeHierarchyCreator_;
        this.dmsConfiguration = dmsConfiguration_;
        this.repositoryService = repositoryService_;
        ValueParam viewParamName = params.getValueParam(SPACE_DRIVE_VIEW);
        if (viewParamName != null) {
            this.viewNodeName = viewParamName.getValue();
        } else {
            logger.warn((Object)"No such property found: space.drive.view\nPlease make sure to have the correct ECMS view name.");
        }
    }

    public void spaceCreated(SpaceLifeCycleEvent event) {
        String groupId = event.getSpace().getGroupId();
        String permission = "manager:" + groupId;
        try {
            if (this.viewNodeName != null) {
                this.editSpaceDriveViewPermissions(this.viewNodeName, permission);
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)"Can not edit view's permissions for view node: null");
            }
        }
        catch (Exception e) {
            logger.error((Object)("Can not edit view's permission for space drive: " + groupId), (Throwable)e);
        }
    }

    private void editSpaceDriveViewPermissions(String viewNodeName, String permission) throws RepositoryException {
        DMSRepositoryConfiguration dmsRepoConfig;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Trying to add permission " + permission + " for ECMS view " + viewNodeName));
        }
        String viewsPath = this.nodeHierarchyCreator.getJcrPath("userViewsPath");
        ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
        Session session = manageableRepository.getSystemSession((dmsRepoConfig = this.dmsConfiguration.getConfig()).getSystemWorkspace());
        Node viewHomeNode = (Node)session.getItem(viewsPath);
        if (viewHomeNode.hasNode(viewNodeName)) {
            Node contentNode = viewHomeNode.getNode(viewNodeName);
            String contentNodePermissions = contentNode.getProperty("exo:accessPermissions").getString();
            contentNode.setProperty("exo:accessPermissions", contentNodePermissions.concat(",").concat(permission));
            viewHomeNode.save();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Permission " + permission + " added with success to ECMS view " + viewNodeName));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Can not find view node: " + viewNodeName));
        }
    }

    public void applicationActivated(SpaceLifeCycleEvent event) {
    }

    public void applicationAdded(SpaceLifeCycleEvent event) {
    }

    public void applicationDeactivated(SpaceLifeCycleEvent event) {
    }

    public void applicationRemoved(SpaceLifeCycleEvent event) {
    }

    public void grantedLead(SpaceLifeCycleEvent event) {
    }

    public void joined(SpaceLifeCycleEvent event) {
    }

    public void left(SpaceLifeCycleEvent event) {
    }

    public void revokedLead(SpaceLifeCycleEvent event) {
    }

    public void spaceRemoved(SpaceLifeCycleEvent event) {
    }
}

