/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webos.webui.page;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.exoplatform.application.registry.Application;
import org.exoplatform.application.registry.ApplicationCategory;
import org.exoplatform.application.registry.ApplicationRegistryService;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.ApplicationState;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.TransientApplicationState;
import org.exoplatform.portal.webui.application.PortletState;
import org.exoplatform.portal.webui.application.UIPortlet;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.PortalDataMapper;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.webos.webui.page.UIDesktopPage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="system:/groovy/portal/webui/application/UIAddNewApplication.gtmpl", events={@EventConfig(listeners={UIMaskWorkspace.CloseActionListener.class}), @EventConfig(listeners={AddApplicationActionListener.class})})
public class UIAddNewApplication
extends UIContainer {
    private List<ApplicationCategory> listAppCategories = new ArrayList<ApplicationCategory>();
    private UIComponent uiComponentParent;
    private boolean isInPage;
    private UserACL userACL = (UserACL)this.getApplicationComponent(UserACL.class);

    public UIAddNewApplication() throws Exception {
        this.initApplicationCategories();
    }

    public List<ApplicationCategory> getApplicationCategories() throws Exception {
        return this.listAppCategories;
    }

    private void initApplicationCategories() throws Exception {
        ApplicationRegistryService prService = (ApplicationRegistryService)this.getApplicationComponent(ApplicationRegistryService.class);
        String remoteUser = WebuiRequestContext.getCurrentInstance().getRemoteUser();
        if (remoteUser == null || remoteUser.equals("")) {
            return;
        }
        List appCategories = prService.getApplicationCategories((Comparator)new ApplicationCategoryComparator());
        Iterator cateItr = appCategories.iterator();
        while (cateItr.hasNext()) {
            ApplicationCategory cate = (ApplicationCategory)cateItr.next();
            if (!this.hasPermission(cate.getAccessPermissions()) || this.filterApps(cate).size() < 1) {
                cateItr.remove();
                continue;
            }
            Collections.sort(cate.getApplications(), new ApplicationComparator());
        }
        this.listAppCategories = appCategories;
    }

    private List<Application> filterApps(ApplicationCategory applicationCategory) {
        ArrayList<Application> applications = new ArrayList<Application>();
        if (applicationCategory.getApplications() == null) {
            return applications;
        }
        for (Application app : applicationCategory.getApplications()) {
            if (!this.hasPermission(app.getAccessPermissions())) continue;
            applications.add(app);
        }
        applicationCategory.setApplications(applications);
        return applications;
    }

    private boolean hasPermission(List<String> accessPermissions) {
        if (accessPermissions == null || accessPermissions.size() == 0) {
            return false;
        }
        for (String permission : accessPermissions) {
            if (!this.userACL.hasPermission(permission)) continue;
            return true;
        }
        return false;
    }

    public UIComponent getUiComponentParent() {
        return this.uiComponentParent;
    }

    public void setUiComponentParent(UIComponent uiComponentParent) {
        this.uiComponentParent = uiComponentParent;
    }

    public boolean isInPage() {
        return this.isInPage;
    }

    public void setInPage(boolean isInPage) {
        this.isInPage = isInPage;
    }

    private Application getApplication(String id) throws Exception {
        List<ApplicationCategory> pCategories = this.getApplicationCategories();
        for (ApplicationCategory pCategory : pCategories) {
            List applications = pCategory.getApplications();
            for (Application application : applications) {
                if (!application.getId().equals(id)) continue;
                return application;
            }
        }
        return null;
    }

    private static void addApplicationToPage(Event<UIAddNewApplication> event, boolean atStartup) throws Exception {
        UIPortalApplication uiPortalApp = Util.getUIPortalApplication();
        UIPortal uiPortal = uiPortalApp.getCurrentSite();
        PortalRequestContext pcontext = Util.getPortalRequestContext();
        UIDesktopPage uiDesktopPage = (UIDesktopPage)uiPortal.findFirstComponentOfType(UIDesktopPage.class);
        if (uiDesktopPage == null) {
            pcontext.addUIComponentToUpdateByAjax(uiPortalApp.getChildById("UIWorkingWorkspace"));
            UIMaskWorkspace maskWorkspace = (UIMaskWorkspace)uiPortalApp.getChildById("UIMaskWorkspace");
            maskWorkspace.createEvent("Close", Event.Phase.DECODE, event.getRequestContext()).broadcast();
            pcontext.setFullRender(true);
            return;
        }
        String applicationId = event.getRequestContext().getRequestParameter("objectId");
        Application application = ((UIAddNewApplication)((Object)event.getSource())).getApplication(applicationId);
        ApplicationType appType = application.getType();
        UIPortlet uiPortlet = (UIPortlet)uiDesktopPage.createUIComponent(UIPortlet.class, null, null);
        TransientApplicationState appState = new TransientApplicationState(application.getContentId());
        uiPortlet.setState(new PortletState((ApplicationState)appState, appType));
        uiPortlet.setPortletInPortal(false);
        uiPortlet.putSuitedTheme(uiPortalApp.getSkin(), "WebosTheme");
        if (atStartup) {
            uiPortlet.getProperties().setProperty("appStatus", "HIDE");
        }
        String portletName = application.getApplicationName();
        String displayName = application.getDisplayName();
        if (displayName != null) {
            uiPortlet.setTitle(displayName);
        } else if (portletName != null) {
            uiPortlet.setTitle(portletName);
        }
        uiPortlet.setDescription(application.getDescription());
        ArrayList accessPers = application.getAccessPermissions();
        String[] accessPermissions = accessPers.toArray(new String[accessPers.size()]);
        uiPortlet.setAccessPermissions(accessPermissions);
        uiDesktopPage.addChild((UIComponent)uiPortlet);
        if (uiDesktopPage.isModifiable()) {
            Page page = (Page)PortalDataMapper.buildModelObject((UIComponent)uiDesktopPage);
            if (page.getChildren() == null) {
                page.setChildren(new ArrayList());
            }
            DataStorage dataService = (DataStorage)uiPortalApp.getApplicationComponent(DataStorage.class);
            dataService.save(page);
            page = dataService.getPage(page.getPageId());
            page.setModifiable(true);
            uiDesktopPage.getChildren().clear();
            PortalDataMapper.toUIPage((UIPage)uiDesktopPage, (Page)page);
        }
        UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiPortalApp.getChildById("UIWorkingWorkspace");
        pcontext.setFullRender(true);
        pcontext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddApplicationActionListener
    extends EventListener<UIAddNewApplication> {
        public void execute(Event<UIAddNewApplication> event) throws Exception {
            if (((UIAddNewApplication)((Object)event.getSource())).isInPage()) {
                UIAddNewApplication.addApplicationToPage((Event<UIAddNewApplication>)event, false);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ApplicationComparator
    implements Comparator<Application> {
        ApplicationComparator() {
        }

        @Override
        public int compare(Application p1, Application p2) {
            return p1.getDisplayName().compareToIgnoreCase(p2.getDisplayName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ApplicationCategoryComparator
    implements Comparator<ApplicationCategory> {
        ApplicationCategoryComparator() {
        }

        @Override
        public int compare(ApplicationCategory cat1, ApplicationCategory cat2) {
            return cat1.getDisplayName().compareToIgnoreCase(cat2.getDisplayName());
        }
    }
}

