/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.profile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.social.common.ResourceBundleUtil;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/social/webui/profile/UIProfileUserSearch.gtmpl", events={@EventConfig(listeners={SearchActionListener.class})})
public class UIProfileUserSearch
extends UIForm {
    public static final String SEARCH = "Search";
    public static final String USER_CONTACT = "name";
    public static final String GENDER_DEFAULT = "Gender";
    public static final String MALE = "male";
    public static final String FEMALE = "female";
    public static final String REG_FOR_SPLIT = "[^_A-Za-z0-9-.\\s[\\n]]";
    static final String RIGHT_INPUT_PATTERN = "^[\\p{L}][\\p{L}._\\- \\d]+$";
    public static final String POSITION_REGEX_EXPRESSION = "^\\p{L}[\\p{L}\\d._,\\s]+\\p{L}$";
    static final String PREFIX_ADDED_FOR_CHECK = "PrefixAddedForCheck";
    private static final char EMPTY_CHARACTER = '\u0000';
    private static final String ALL_FILTER = "All";
    private List<Identity> identityList = null;
    String selectedChar = null;
    ProfileFilter profileFilter = null;
    String typeOfRelation = null;
    String spaceURL = null;
    private boolean isNewSearch;
    long identitiesCount;
    private boolean hasPeopleTab;
    private int peopleNum;

    public boolean isHasPeopleTab() {
        return this.hasPeopleTab;
    }

    public void setHasPeopleTab(boolean hasPeopleTab) {
        this.hasPeopleTab = hasPeopleTab;
    }

    public int getPeopleNum() {
        return this.peopleNum;
    }

    public void setPeopleNum(int peopleNum) {
        this.peopleNum = peopleNum;
    }

    public void setIdentityList(List<Identity> identityList) throws Exception {
        if (identityList.contains(Utils.getViewerIdentity())) {
            identityList.remove(Utils.getViewerIdentity());
        }
        this.identityList = identityList;
    }

    public final List<Identity> getIdentityList() {
        return this.identityList;
    }

    public final String getSelectedChar() {
        return this.selectedChar;
    }

    public final void setSelectedChar(String selectedChar) {
        this.selectedChar = selectedChar;
    }

    public String getTypeOfRelation() {
        return this.typeOfRelation;
    }

    public void setTypeOfRelation(String typeOfRelation) {
        this.typeOfRelation = typeOfRelation;
    }

    public String getSpaceURL() {
        return this.spaceURL;
    }

    public void setSpaceURL(String spaceURL) {
        this.spaceURL = spaceURL;
    }

    protected String getCurrentUserName() {
        return RequestContext.getCurrentInstance().getRemoteUser();
    }

    protected String getRestContextName() {
        return PortalContainer.getCurrentRestContextName();
    }

    public final ProfileFilter getProfileFilter() {
        return this.profileFilter;
    }

    public final void setProfileFilter(ProfileFilter profileFilter) {
        this.profileFilter = profileFilter;
    }

    public UIProfileUserSearch() throws Exception {
        ResourceBundle resourceBudle = PortalRequestContext.getCurrentInstance().getApplicationResourceBundle();
        String defaultName = resourceBudle.getString("UIProfileUserSearch.label.Name");
        String defaultPos = resourceBudle.getString("UIProfileUserSearch.label.Position");
        String defaultSkills = resourceBudle.getString("UIProfileUserSearch.label.Skills");
        String defaultGender = resourceBudle.getString("UIProfileUserSearch.label.AllGender");
        String defaultMale = resourceBudle.getString("UIProfileUserSearch.label.Male");
        String defaultFeMale = resourceBudle.getString("UIProfileUserSearch.label.FeMale");
        ArrayList<SelectItemOption> options = new ArrayList<SelectItemOption>();
        options.add(new SelectItemOption((Object)defaultGender));
        options.add(new SelectItemOption((Object)defaultMale));
        options.add(new SelectItemOption((Object)defaultFeMale));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(SEARCH, USER_CONTACT, defaultName));
        this.addUIFormInput((UIFormInput)new UIFormStringInput("position", "position", defaultPos));
        this.addUIFormInput((UIFormInput)new UIFormStringInput("skills", "skills", defaultSkills));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox("gender", "gender", options)).setId("GenderList");
        this.profileFilter = new ProfileFilter();
        this.setHasPeopleTab(false);
        this.setSelectedChar(ALL_FILTER);
    }

    protected void resetUIComponentValues() {
        UIFormStringInput uiName = (UIFormStringInput)this.getChildById(SEARCH);
        UIFormStringInput uiPos = (UIFormStringInput)this.getChildById("position");
        UIFormStringInput uiSkills = (UIFormStringInput)this.getChildById("skills");
        UIFormSelectBox uiGender = (UIFormSelectBox)this.getChildById("gender");
        ResourceBundle resourceBudle = PortalRequestContext.getCurrentInstance().getApplicationResourceBundle();
        String defaultName = resourceBudle.getString("UIProfileUserSearch.label.Name");
        String defaultPos = resourceBudle.getString("UIProfileUserSearch.label.Position");
        String defaultSkills = resourceBudle.getString("UIProfileUserSearch.label.Skills");
        String defaultGender = resourceBudle.getString("UIProfileUserSearch.label.AllGender");
        String defaultMale = resourceBudle.getString("UIProfileUserSearch.label.Male");
        String defaultFeMale = resourceBudle.getString("UIProfileUserSearch.label.FeMale");
        uiName.setValue((Object)defaultName);
        uiPos.setValue((Object)defaultPos);
        uiSkills.setValue((Object)defaultSkills);
        uiGender.setDefaultValue((Object)defaultGender);
        ((SelectItemOption)uiGender.getOptions().get(0)).setValue((Object)defaultGender);
        ((SelectItemOption)uiGender.getOptions().get(1)).setValue((Object)defaultMale);
        ((SelectItemOption)uiGender.getOptions().get(2)).setValue((Object)defaultFeMale);
        ((SelectItemOption)uiGender.getOptions().get(0)).setLabel(defaultGender);
        ((SelectItemOption)uiGender.getOptions().get(1)).setLabel(defaultMale);
        ((SelectItemOption)uiGender.getOptions().get(2)).setLabel(defaultFeMale);
    }

    public String getSelectedNode() {
        PortalRequestContext pcontext = Util.getPortalRequestContext();
        String currentPath = pcontext.getControllerContext().getParameter(QualifiedName.parse((String)"gtn:path"));
        if (currentPath.split("/").length >= 2) {
            return currentPath.split("/")[1];
        }
        return currentPath;
    }

    public List<Identity> getIdentitiesBySkills(List<Identity> identities) {
        ArrayList<Identity> identityLst = new ArrayList<Identity>();
        String prof = null;
        String skill = this.getProfileFilter().getSkills().trim().toLowerCase();
        if (identities.size() == 0) {
            return identityLst;
        }
        for (Identity id : identities) {
            Profile profile = id.getProfile();
            ArrayList experiences = (ArrayList)profile.getProperty("experiences");
            if (experiences == null) continue;
            block1: for (HashMap exp : experiences) {
                String[] items;
                prof = (String)exp.get("skills");
                if (prof == null) continue;
                Pattern p = Pattern.compile(REG_FOR_SPLIT);
                for (String item : items = p.split(prof)) {
                    if (!item.toLowerCase().matches(skill)) continue;
                    identityLst.add(id);
                    continue block1;
                }
            }
        }
        return UIProfileUserSearch.GetUniqueIdentities(identityLst);
    }

    protected String getPeopleFoundLabel() {
        String labelArg = "UIProfileUserSearch.label.FoundPersonFilter";
        if (this.getPeopleNum() > 1) {
            labelArg = "UIProfileUserSearch.label.FoundPeopleFilter";
        }
        String searchCondition = this.getSelectedChar();
        if (this.selectedChar == null) {
            labelArg = "UIProfileUserSearch.label.FoundPersonSearch";
            if (this.getPeopleNum() > 1) {
                labelArg = "UIProfileUserSearch.label.FoundPeopleSearch";
            }
            searchCondition = this.getProfileFilter().getName();
        }
        return ResourceBundleUtil.replaceArguments((String)WebuiRequestContext.getCurrentInstance().getApplicationResourceBundle().getString(labelArg), (String[])new String[]{Integer.toString(this.getPeopleNum()), searchCondition != null ? searchCondition : " "});
    }

    private static Collection<Identity> Union(Collection<Identity> identities1, Collection<Identity> identities2) {
        HashSet<Identity> identities = new HashSet<Identity>(identities1);
        identities.addAll(new HashSet<Identity>(identities2));
        return new ArrayList<Identity>(identities);
    }

    private static ArrayList<Identity> GetUniqueIdentities(Collection<Identity> identities) {
        return (ArrayList)UIProfileUserSearch.Union(identities, identities);
    }

    public final boolean isNewSearch() {
        return this.isNewSearch;
    }

    public final void setNewSearch(boolean isNewSearch) {
        this.isNewSearch = isNewSearch;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SearchActionListener
    extends EventListener<UIProfileUserSearch> {
        public final void execute(Event<UIProfileUserSearch> event) throws Exception {
            WebuiRequestContext ctx = event.getRequestContext();
            UIProfileUserSearch uiSearch = (UIProfileUserSearch)((Object)event.getSource());
            String charSearch = ctx.getRequestParameter("objectId");
            ProfileFilter filter = new ProfileFilter();
            ArrayList<Identity> excludedIdentityList = new ArrayList<Identity>();
            excludedIdentityList.add(Utils.getViewerIdentity());
            filter.setExcludedIdentityList(excludedIdentityList);
            uiSearch.invokeSetBindingBean(filter);
            ResourceBundle resApp = ctx.getApplicationResourceBundle();
            String defaultNameVal = resApp.getString(uiSearch.getId() + ".label.Name");
            String defaultPosVal = resApp.getString(uiSearch.getId() + ".label.Position");
            String defaultSkillsVal = resApp.getString(uiSearch.getId() + ".label.Skills");
            String defaultGenderVal = resApp.getString(uiSearch.getId() + ".label.AllGender");
            try {
                uiSearch.setSelectedChar(charSearch);
                if (charSearch != null) {
                    ((UIFormStringInput)uiSearch.getChildById(UIProfileUserSearch.SEARCH)).setValue((Object)defaultNameVal);
                    ((UIFormStringInput)uiSearch.getChildById("position")).setValue((Object)defaultPosVal);
                    ((UIFormStringInput)uiSearch.getChildById("skills")).setValue((Object)defaultSkillsVal);
                    ((UIFormStringInput)uiSearch.getChildById("gender")).setValue((Object)defaultGenderVal);
                    filter.setName(charSearch);
                    filter.setPosition("");
                    filter.setSkills("");
                    filter.setGender("");
                    filter.setFirstCharacterOfName(charSearch.toCharArray()[0]);
                    if (UIProfileUserSearch.ALL_FILTER.equals(charSearch)) {
                        filter.setFirstCharacterOfName('\u0000');
                        filter.setName("");
                    }
                    uiSearch.setProfileFilter(filter);
                } else {
                    uiSearch.setSelectedChar(null);
                    if (!this.isValidInput(filter)) {
                        uiSearch.setIdentityList(new ArrayList<Identity>());
                    } else {
                        if (filter.getName() == null || filter.getName().equals(defaultNameVal)) {
                            filter.setName("");
                        }
                        if (filter.getPosition() == null || filter.getPosition().equals(defaultPosVal)) {
                            filter.setPosition("");
                        }
                        if (filter.getSkills() == null || filter.getSkills().equals(defaultSkillsVal)) {
                            filter.setSkills("");
                        }
                        if (filter.getGender().equals(defaultGenderVal)) {
                            filter.setGender("");
                        }
                        String skills = null;
                        filter.setFirstCharacterOfName('\u0000');
                        uiSearch.setProfileFilter(filter);
                        skills = filter.getSkills();
                        if (skills.length() > 0) {
                            skills = skills.isEmpty() ? "*" : skills;
                            skills = skills.charAt(0) != '*' ? "*" + skills : skills;
                            skills = skills.charAt(skills.length() - 1) != '*' ? (skills = skills + "*") : skills;
                            skills = skills.indexOf("*") >= 0 ? skills.replace("*", ".*") : skills;
                            skills = skills.indexOf("%") >= 0 ? skills.replace("%", ".*") : skills;
                            Pattern.compile(skills);
                            filter.setSkills(skills);
                            uiSearch.setProfileFilter(filter);
                        }
                    }
                }
                uiSearch.setNewSearch(true);
            }
            catch (Exception e) {
                uiSearch.setIdentityList(new ArrayList<Identity>());
            }
            Event searchEvent = uiSearch.getParent().createEvent(UIProfileUserSearch.SEARCH, Event.Phase.DECODE, ctx);
            if (searchEvent != null) {
                searchEvent.broadcast();
            }
        }

        private boolean isValidInput(ProfileFilter input) {
            String contactName = input.getName();
            String contactNameForCheck = null;
            if (contactName != null) {
                contactNameForCheck = contactName.trim().replace("*", "");
                contactNameForCheck = contactNameForCheck.replace("%", "");
                contactNameForCheck = UIProfileUserSearch.PREFIX_ADDED_FOR_CHECK + contactNameForCheck;
                if (!contactNameForCheck.matches(UIProfileUserSearch.RIGHT_INPUT_PATTERN)) {
                    return false;
                }
            }
            return true;
        }
    }
}

