/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.upgrade.plugins;

import java.util.List;
import org.exoplatform.application.gadget.Gadget;
import org.exoplatform.application.gadget.GadgetRegistryService;
import org.exoplatform.application.gadget.SourceStorage;
import org.exoplatform.application.gadget.impl.GadgetRegistryServiceImpl;
import org.exoplatform.commons.chromattic.ChromatticLifeCycle;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.platform.upgrade.plugins.GadgetUpgrade;
import org.exoplatform.platform.upgrade.plugins.LocalGadgetImporter;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class UpgradeLocalGadgetsPlugin
extends UpgradeProductPlugin {
    private static final Log log = ExoLogger.getLogger(UpgradeLocalGadgetsPlugin.class);
    private List<GadgetUpgrade> gadgets;
    protected RepositoryService repositoryService;
    protected ConfigurationManager configurationManager;
    protected SourceStorage sourceStorage;
    protected GadgetRegistryServiceImpl gadgetRegistryService;

    public UpgradeLocalGadgetsPlugin(ConfigurationManager configurationManager, RepositoryService repositoryService, SourceStorage sourceStorage, GadgetRegistryService gadgetRegistryService, InitParams initParams) {
        super(initParams);
        this.gadgets = initParams.getObjectParamValues(GadgetUpgrade.class);
        this.repositoryService = repositoryService;
        this.configurationManager = configurationManager;
        this.sourceStorage = sourceStorage;
        this.gadgetRegistryService = (GadgetRegistryServiceImpl)gadgetRegistryService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        log.info((Object)("processing upgrading gadgets from version " + oldVersion + " to " + newVersion));
        ChromatticLifeCycle lifeCycle = this.gadgetRegistryService.getChromatticLifeCycle();
        try {
            lifeCycle.openContext();
            for (GadgetUpgrade gadgetUpgrade : this.gadgets) {
                try {
                    Gadget gadget = this.gadgetRegistryService.getGadget(gadgetUpgrade.getName());
                    if (gadget == null) {
                        log.warn((Object)("Can't find gadget '" + gadgetUpgrade.getName() + "'."));
                        continue;
                    }
                    log.info((Object)("Replacing gadget " + gadgetUpgrade.getName() + " with new content ..."));
                    this.gadgetRegistryService.getRegistry().removeGadget(gadgetUpgrade.getName());
                    try {
                        LocalGadgetImporter gadgetImporter = new LocalGadgetImporter(gadgetUpgrade.getName(), (GadgetRegistryService)this.gadgetRegistryService, gadgetUpgrade.getPath(), this.configurationManager, PortalContainer.getInstance());
                        gadgetImporter.doImport();
                        gadget = this.gadgetRegistryService.getGadget(gadgetUpgrade.getName());
                        if (gadget != null) {
                            log.info((Object)("gadget " + gadgetUpgrade.getName() + " upgraded successfully."));
                            continue;
                        }
                        log.info((Object)("Gadget " + gadgetUpgrade.getName() + " wasn't imported. It will be imported automatically with GadgetDeployer Service."));
                    }
                    catch (Exception exception) {
                        log.info((Object)("Gadget " + gadgetUpgrade.getName() + " wasn't imported. It will be imported automatically with GadgetDeployer Service."));
                    }
                }
                catch (Exception exception) {
                    log.error((Object)("Error while proceeding '" + gadgetUpgrade.getName() + "' gadget upgrade."), (Throwable)exception);
                }
            }
        }
        finally {
            if (lifeCycle != null) {
                lifeCycle.closeContext(true);
            }
        }
    }

    public boolean shouldProceedToUpgrade(String previousVersion, String newVersion) {
        return true;
    }
}

