/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.repository;

import java.util.ArrayList;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.admin.UIECMAdminPortlet;
import org.exoplatform.ecm.webui.component.admin.repository.UIRepositoryControl;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIGrid;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="system:/groovy/ecm/webui/UIGridWithButton.gtmpl", events={@EventConfig(listeners={DeleteActionListener.class}, confirm="UIRepositoryList.msg.confirm-delete"), @EventConfig(listeners={CloseActionListener.class})})
public class UIRepositoryList
extends UIGrid
implements UIPopupComponent {
    private static String[] REPO_BEAN_FIELD = new String[]{"name", "workspaces", "isdefault", "accesscontrol", "sessiontimeout"};
    private static String[] REPO_ACTION = new String[]{"Delete"};

    public UIRepositoryList() throws Exception {
        this.configure("name", REPO_BEAN_FIELD, REPO_ACTION);
    }

    public String[] getActions() {
        return new String[]{"Close"};
    }

    public void updateGrid() throws Exception {
        RepositoryService rservice = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        String defaultName = rservice.getConfig().getDefaultRepositoryName();
        ArrayList<RepoData> repos = new ArrayList<RepoData>();
        RepositoryEntry repo = rservice.getCurrentRepository().getConfiguration();
        StringBuilder sb = new StringBuilder();
        repo.getWorkspaceEntries();
        for (WorkspaceEntry ws : repo.getWorkspaceEntries()) {
            sb.append(ws.getName()).append(";");
        }
        String name = repo.getName();
        String isDefault = String.valueOf(defaultName.equals(repo.getName()));
        String accessControl = repo.getAccessControl();
        String sessionTime = String.valueOf(repo.getSessionTimeOut());
        String workspace = sb.toString();
        repos.add(new RepoData(name, workspace, isDefault, accessControl, sessionTime));
        ListAccessImpl repoList = new ListAccessImpl(RepoData.class, repos);
        LazyPageList dataPageList = new LazyPageList((ListAccess)repoList, 10);
        this.getUIPageIterator().setPageList((PageList)dataPageList);
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public class RepoData {
        String name;
        String workspaces;
        String isdefault = "false";
        String accesscontrol;
        String sessiontimeout;

        public RepoData(String rname, String rworkspaces, String risdefault, String raccess, String rtime) {
            this.name = rname;
            this.workspaces = rworkspaces;
            this.isdefault = risdefault;
            this.accesscontrol = raccess;
            this.sessiontimeout = rtime;
        }

        public String getName() {
            return this.name;
        }

        public String getWorkspaces() {
            return this.workspaces;
        }

        public String getIsdefault() {
            return this.isdefault;
        }

        public String getAccesscontrol() {
            return this.accesscontrol;
        }

        public String getSessiontimeout() {
            return this.sessiontimeout;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CloseActionListener
    extends EventListener<UIRepositoryList> {
        public void execute(Event<UIRepositoryList> event) throws Exception {
            UIPopupContainer uiPopup = (UIPopupContainer)((UIRepositoryList)((Object)event.getSource())).getAncestorOfType(UIPopupContainer.class);
            uiPopup.deActivate();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopup);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteActionListener
    extends EventListener<UIRepositoryList> {
        public void execute(Event<UIRepositoryList> event) throws Exception {
            UIRepositoryList uiList = (UIRepositoryList)((Object)event.getSource());
            UIECMAdminPortlet uiAdminPortlet = (UIECMAdminPortlet)uiList.getAncestorOfType(UIECMAdminPortlet.class);
            UIRepositoryControl repositoryControl = (UIRepositoryControl)uiAdminPortlet.getChild(UIRepositoryControl.class);
            UIRepositoryControl uiControl = (UIRepositoryControl)uiAdminPortlet.findFirstComponentOfType(UIRepositoryControl.class);
            RepositoryService rservice = (RepositoryService)uiList.getApplicationComponent(RepositoryService.class);
            String repoName = event.getRequestContext().getRequestParameter("objectId");
            UIApplication uiApp = (UIApplication)uiList.getAncestorOfType(UIApplication.class);
            Object[] args = new Object[]{repoName};
            if (repoName.equals(repositoryControl.getSelectedRepo()) || !rservice.canRemoveRepository(repoName)) {
                uiApp.addMessage(new ApplicationMessage("UIRepositoryList.msg.cannot-delete", args));
                return;
            }
            rservice.removeRepository(repoName);
            if (rservice.getConfig().isRetainable()) {
                rservice.getConfig().retain();
            }
            uiList.updateGrid();
            uiControl.reloadValue(true, rservice);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiList.getAncestorOfType(UIPopupContainer.class));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiControl);
        }
    }
}

