/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.ext.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.ks.common.CommonUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForumTransformHTML {
    public static String cleanHtmlCode(String sms, List<String> bbcs) {
        if (CommonUtils.isEmpty((String)sms)) {
            return CommonUtils.EMPTY_STR;
        }
        sms = StringUtils.replace((String)sms, (String)"\n", (String)CommonUtils.SPACE);
        if (bbcs != null && bbcs.size() > 0) {
            ArrayList<String> bbcList = new ArrayList<String>();
            bbcList.addAll(bbcs);
            for (String bbc : bbcs) {
                bbcList.add(bbc.toLowerCase());
            }
            int lastIndex = 0;
            int tagIndex = 0;
            for (String bbc : bbcList) {
                String start = "[" + bbc;
                String end = "[/" + bbc + "]";
                lastIndex = 0;
                tagIndex = 0;
                while ((tagIndex = sms.indexOf(start, lastIndex)) != -1) {
                    lastIndex = tagIndex + 1;
                    try {
                        int clsIndex = sms.indexOf(end, tagIndex);
                        String content = sms.substring(tagIndex, clsIndex);
                        String content_ = content.substring(content.indexOf("]") + 1);
                        sms = StringUtils.replace((String)sms, (String)(content + end), (String)content_);
                    }
                    catch (Exception e) {}
                }
            }
            sms = StringUtils.replace((String)sms, (String)"[U]", (String)"");
            sms = StringUtils.replace((String)sms, (String)"[/U]", (String)"");
            sms = StringUtils.replace((String)sms, (String)"[u]", (String)"");
            sms = StringUtils.replace((String)sms, (String)"[/u]", (String)"");
        }
        String scriptregex = "<(script|style)[^>]*>[^<]*</(script|style)>";
        Pattern p1 = Pattern.compile(scriptregex, 2);
        Matcher m1 = p1.matcher(sms);
        sms = m1.replaceAll("");
        String tagregex = "<[^>]*>";
        Pattern p2 = Pattern.compile(tagregex);
        Matcher m2 = p2.matcher(sms);
        sms = m2.replaceAll("");
        String multiplenewlines = "(\\n{1,2})(\\s*\\n)+";
        sms = sms.replaceAll(multiplenewlines, "$1");
        return sms;
    }

    public static String getTitleInHTMLCode(String s) throws Exception {
        return ForumTransformHTML.getTitleInHTMLCode(s, new ArrayList<String>());
    }

    public static String getTitleInHTMLCode(String s, List<String> bbcs) throws Exception {
        if (CommonUtils.isEmpty((String)s)) {
            return CommonUtils.EMPTY_STR;
        }
        if (s.length() > 500) {
            s = s.substring(0, 500);
        }
        s = s.replaceAll("&nbsp;", CommonUtils.SPACE).replaceAll("<br/>", CommonUtils.SPACE).replaceAll("( \\s*)", CommonUtils.SPACE);
        s = ForumTransformHTML.cleanHtmlCode(s, bbcs);
        s = ForumTransformHTML.removeCharterStrange(s);
        s = CommonUtils.decodeSpecialCharToHTMLnumber((String)s);
        return s.trim();
    }

    public static String removeCharterStrange(String s) {
        if (s == null || s.length() <= 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            if (s.codePointAt(i) <= 31) continue;
            builder.append(s.charAt(i));
        }
        return builder.toString();
    }

    public static String enCodeHTML(String s) {
        StringBuffer buffer = new StringBuffer();
        if (s != null) {
            s = s.replaceAll("(<p>((\\&nbsp;)*)(\\s*)?</p>)|(<p>((\\&nbsp;)*)?(\\s*)</p>)", "<br/>").trim();
            s = s.replaceFirst("(<br/>)*", "");
            s = s.replaceAll("(\\w|\\$)(>?,?\\.?\\*?\\!?\\&?\\%?\\]?\\)?\\}?)(<br/><br/>)*", "$1$2");
            for (int j = 0; j < s.trim().length(); ++j) {
                char c = s.charAt(j);
                if (c == '<') {
                    buffer.append("&lt;");
                    continue;
                }
                if (c == '>') {
                    buffer.append("&gt;");
                    continue;
                }
                if (c == '\'') {
                    buffer.append("&#39");
                    continue;
                }
                buffer.append(c);
            }
        }
        return buffer.toString();
    }

    public static String fixAddBBcodeAction(String b) {
        int tagIndex = 0;
        int lastIndex = 0;
        String text_ = "";
        StringBuilder builder = new StringBuilder();
        String[] tagBBcode = new String[]{"quote", "code", "QUOTE", "CODE"};
        for (int i = 0; i < tagBBcode.length; ++i) {
            String start = "[" + tagBBcode[i];
            String end = "[/" + tagBBcode[i] + "]";
            while ((tagIndex = b.indexOf(start, lastIndex)) != -1) {
                lastIndex = tagIndex + 1;
                try {
                    int t;
                    int clsIndex = b.indexOf(end, tagIndex);
                    String text = b.substring(tagIndex, clsIndex);
                    if (text == null || text.trim().length() == 0) continue;
                    text_ = text;
                    builder = new StringBuilder();
                    if (text.indexOf("<p") > text.indexOf("</p")) {
                        text = StringUtils.replaceOnce((String)text, (String)"</p>", (String)"");
                        t = text.lastIndexOf("<p>");
                        builder.append(text.substring(0, t));
                        if (text.length() > t + 3) {
                            builder.append(text.substring(t + 3));
                        }
                    }
                    if ((text = builder.toString()) != null && text.length() > 0) {
                        b = StringUtils.replace((String)b, (String)text_, (String)text);
                        text_ = text;
                    } else {
                        text = text_;
                    }
                    builder = new StringBuilder();
                    if (text.indexOf("<span") > text.indexOf("</span")) {
                        text = StringUtils.replaceOnce((String)text, (String)"</span>", (String)"");
                        t = text.lastIndexOf("<span");
                        builder.append(text.substring(0, t));
                        if (text.length() > t + 6) {
                            builder.append(text.substring(t + 6));
                        }
                    }
                    if ((text = builder.toString()) == null || text.length() <= 0) continue;
                    b = StringUtils.replace((String)b, (String)text_, (String)text);
                }
                catch (Exception e) {}
            }
        }
        return b;
    }
}

