/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.gadgets.services;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.application.gadget.Gadget;
import org.exoplatform.application.gadget.GadgetRegistryService;
import org.exoplatform.application.registry.Application;
import org.exoplatform.application.registry.ApplicationCategory;
import org.exoplatform.application.registry.ApplicationRegistryService;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.platform.gadgets.listeners.InitNewUserDashboardListener;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

public class PopulateGadgetRegisryService
implements Startable {
    private static final String DEFAULT_GADGETS_CATEGORY_NAME = "Gadgets";
    private static String CATEGORY_NAME;
    private static String GADGETS_CATEGORY_ACCESS_PERMISSION;
    private static Log logger;
    private GadgetRegistryService gadgetRegistryService = null;
    private ApplicationRegistryService applicationRegistryService = null;
    private List<Gadget> gadgets;

    public PopulateGadgetRegisryService(GadgetRegistryService gadgetRegistryService, ApplicationRegistryService applicationRegistryService, InitParams initParams) {
        CATEGORY_NAME = initParams.getValueParam("gadgetsCategoryName").getValue();
        if (CATEGORY_NAME == null) {
            CATEGORY_NAME = DEFAULT_GADGETS_CATEGORY_NAME;
            logger.warn((Object)("Failed to retrieve " + initParams.getValueParam("gadgetsCategoryName").getName() + " init param. Default category name will be used: " + DEFAULT_GADGETS_CATEGORY_NAME));
        }
        if ((GADGETS_CATEGORY_ACCESS_PERMISSION = initParams.getValueParam("gadgetsCategoryAccessPermission").getValue()) == null) {
            GADGETS_CATEGORY_ACCESS_PERMISSION = "Everyone";
            logger.warn((Object)("Failed to retrieve " + initParams.getValueParam("gadgetsCategoryAccessPermission").getName() + " init param. Default access permission will be used: " + "Everyone"));
        }
        this.gadgets = initParams.getObjectParamValues(Gadget.class);
        this.gadgetRegistryService = gadgetRegistryService;
        this.applicationRegistryService = applicationRegistryService;
    }

    public void start() {
        for (Gadget gadget : this.gadgets) {
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            try {
                String[] permissionEntry;
                if (this.gadgetRegistryService.getGadget(gadget.getName()) == null) {
                    this.gadgetRegistryService.saveGadget(gadget);
                }
                ArrayList<String> permissions = new ArrayList<String>();
                for (String entry : permissionEntry = GADGETS_CATEGORY_ACCESS_PERMISSION.split(",")) {
                    permissions.add(entry);
                }
                Application registryApplication = new Application();
                registryApplication.setApplicationName(gadget.getName());
                registryApplication.setType(ApplicationType.GADGET);
                registryApplication.setDisplayName(gadget.getTitle());
                registryApplication.setContentId(gadget.getName());
                String description = gadget.getDescription() == null || gadget.getDescription().length() < 1 ? gadget.getName() : gadget.getDescription();
                registryApplication.setDescription(description);
                registryApplication.setAccessPermissions(permissions);
                registryApplication.setCategoryName(CATEGORY_NAME);
                if (this.applicationRegistryService.getApplicationCategory(CATEGORY_NAME) == null) {
                    ApplicationCategory category = new ApplicationCategory();
                    category.setName(CATEGORY_NAME);
                    category.setDisplayName(CATEGORY_NAME);
                    category.setDescription(CATEGORY_NAME);
                    category.setAccessPermissions(permissions);
                    this.applicationRegistryService.save(category, registryApplication);
                    continue;
                }
                this.applicationRegistryService.save(this.applicationRegistryService.getApplicationCategory(CATEGORY_NAME), registryApplication);
            }
            catch (Exception e) {
                logger.error((Object)("Error while saving gadget: " + gadget.getName() + " with " + CATEGORY_NAME + " application category. "), (Throwable)e);
                throw new RuntimeException(e);
            }
            finally {
                RequestLifeCycle.end();
            }
        }
    }

    public void stop() {
    }

    static {
        logger = ExoLogger.getExoLogger(InitNewUserDashboardListener.class);
    }
}

