/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.common.rest;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.application.gadget.Gadget;
import org.exoplatform.application.gadget.GadgetRegistryService;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.Dashboard;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.TransientApplicationState;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.mop.user.UserPortalContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;

@Path(value="/dashboards")
public class DashboardInformationRESTService
implements ResourceContainer {
    private Log logger = ExoLogger.getLogger(this.getClass());
    protected static final String WS_ROOT_PATH = "/dashboards";
    protected static final String STANDALONE_ROOT_PATH = "/standalone";
    private final UserPortalConfigService userPortalConfigService;
    private final DataStorage dataStorageService;
    private final GadgetRegistryService gadgetRegistryService;
    private List<JsonGadgetInfo> gadgetsInfo;
    private static final UserPortalContext NULL_CONTEXT = new UserPortalContext(){

        public ResourceBundle getBundle(UserNavigation navigation) {
            return null;
        }

        public Locale getUserLocale() {
            return Locale.ENGLISH;
        }
    };

    public DashboardInformationRESTService(UserPortalConfigService userPortalConfigService, DataStorage dataStorageService, GadgetRegistryService gadgetRegistryService) {
        this.userPortalConfigService = userPortalConfigService;
        this.dataStorageService = dataStorageService;
        this.gadgetRegistryService = gadgetRegistryService;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getDashboards(@Context UriInfo uriInfo) {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        try {
            String userId = ConversationState.getCurrent().getIdentity().getUserId();
            UserNavigation userNavigation = this.getUserNavigation(userId);
            UserPortal userPortal = this.getUserPortal(userId);
            UserNode rootNode = userPortal.getNode(userNavigation, Scope.ALL, null, null);
            Collection nodes = rootNode.getChildren();
            LinkedList<JsonDashboardInfo> list = new LinkedList<JsonDashboardInfo>();
            String wsSubPath = "";
            String dashboardSubPath = "";
            URI wsURI = null;
            URI dashboardURI = null;
            for (UserNode node : nodes) {
                Application appDashboard = (Application)this.extractDashboard((Container)this.dataStorageService.getPage(node.getPageRef()));
                if (appDashboard == null || !(appDashboard.getState() instanceof TransientApplicationState)) continue;
                JsonDashboardInfo info = new JsonDashboardInfo();
                info.setId(node.getId());
                info.setLabel(node.getEncodedResolvedLabel());
                wsSubPath = PortalContainer.getCurrentRestContextName() + "/private" + WS_ROOT_PATH + "/" + userId + "/" + this.getPageName(node.getPageRef());
                wsURI = uriInfo.getBaseUriBuilder().replaceMatrix(wsSubPath).build(new Object[0]);
                dashboardSubPath = PortalContainer.getCurrentPortalContainerName() + "/u/" + userId + "/" + node.getName();
                dashboardURI = uriInfo.getBaseUriBuilder().replaceMatrix(dashboardSubPath).build(new Object[0]);
                info.setLink(wsURI.toString());
                info.setHtml(dashboardURI.toString());
                list.add(info);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Getting Dashboards Information");
            }
            return Response.ok(list, (String)"application/json").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            this.logger.error((Object)"An error occured while getting dashboards information.", (Throwable)e);
            return Response.status((int)500).cacheControl(cacheControl).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/{userName}/{dashboardName}")
    @Produces(value={"application/json"})
    public Response getGadgetInformation(@PathParam(value="userName") String userName, @PathParam(value="dashboardName") String dashboardName, @Context UriInfo uriInfo) {
        this.gadgetsInfo = new LinkedList<JsonGadgetInfo>();
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        try {
            Application appDashboard;
            Page page;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Getting Gadgets Information");
            }
            if ((page = this.dataStorageService.getPage("user::" + userName + "::" + dashboardName)) != null && page.getChildren() != null && page.getChildren().size() > 0 && (appDashboard = (Application)this.extractDashboard((Container)page)) != null) {
                Dashboard dashboard = this.dataStorageService.loadDashboard(appDashboard.getStorageId());
                this.extractGadgets((Container)dashboard);
                int i = 0;
                String standaloneSubPath = "";
                URI standaloneURI = null;
                String iconSubPath = "";
                URI iconURI = null;
                for (JsonGadgetInfo info : this.gadgetsInfo) {
                    standaloneSubPath = info.getGadgetUrl();
                    standaloneURI = uriInfo.getBaseUriBuilder().replaceMatrix(standaloneSubPath).build(new Object[0]);
                    info.setGadgetUrl(standaloneURI.toString());
                    if (info.getGadgetIcon() != null && info.getGadgetIcon().length() > 0 && !info.getGadgetIcon().startsWith("http")) {
                        iconSubPath = info.getGadgetIcon();
                        iconURI = uriInfo.getBaseUriBuilder().replaceMatrix(iconSubPath).build(new Object[0]);
                        info.setGadgetIcon(iconURI.toString());
                    }
                    this.gadgetsInfo.set(i++, info);
                }
            }
            Response response = Response.ok(this.gadgetsInfo, (String)"application/json").cacheControl(cacheControl).build();
            return response;
        }
        catch (Exception e) {
            this.logger.error((Object)"An error occured while getting dashboards information.", (Throwable)e);
            Response response = Response.status((int)500).cacheControl(cacheControl).build();
            return response;
        }
        finally {
            try {
                RequestLifeCycle.end();
            }
            catch (Exception e) {
                this.logger.warn((Object)("An exception has occurred while proceed RequestLifeCycle.end() : " + e.getMessage()));
            }
        }
    }

    private void extractGadgets(Container container) throws Exception {
        if (container != null) {
            ArrayList children = container.getChildren();
            for (ModelObject child : children) {
                if (child instanceof Application) {
                    Application application = (Application)child;
                    if (ApplicationType.GADGET != application.getType()) continue;
                    String gadgetName = this.dataStorageService.getId(application.getState());
                    Gadget gadget = this.gadgetRegistryService.getGadget(gadgetName);
                    JsonGadgetInfo info = new JsonGadgetInfo();
                    info.setGadgetName(gadget.getName());
                    info.setGadgetUrl(PortalContainer.getCurrentPortalContainerName() + STANDALONE_ROOT_PATH + "/" + application.getStorageId());
                    info.setGadgetIcon(gadget.getThumbnail());
                    info.setGadgetDescription(gadget.getDescription());
                    this.gadgetsInfo.add(info);
                    continue;
                }
                if (!(child instanceof Container)) continue;
                Container childContainer = (Container)child;
                this.extractGadgets(childContainer);
            }
        }
    }

    private ModelObject extractDashboard(Container container) throws Exception {
        if (container != null) {
            ArrayList children = container.getChildren();
            for (ModelObject child : children) {
                if (child instanceof Application) {
                    Application application = (Application)child;
                    if (ApplicationType.PORTLET != application.getType()) continue;
                    return application;
                }
                if (!(child instanceof Container)) continue;
                Container childContainer = (Container)child;
                return this.extractDashboard(childContainer);
            }
        }
        return null;
    }

    private UserNavigation getUserNavigation(String userId) throws Exception {
        UserPortal userPortal = this.getUserPortal(userId);
        return userPortal.getNavigation(SiteKey.user((String)userId));
    }

    private UserPortal getUserPortal(String userId) throws Exception {
        UserPortalConfig portalConfig = this.userPortalConfigService.getUserPortalConfig(this.userPortalConfigService.getDefaultPortal(), userId, NULL_CONTEXT);
        return portalConfig.getUserPortal();
    }

    private String getPageName(String pageRef) {
        String pageName = "";
        String[] refs = pageRef.split("::");
        pageName = refs[refs.length - 1];
        return pageName;
    }

    public static class JsonGadgetInfo {
        String gadgetName;
        String gadgetUrl;
        String gadgetIcon;
        String gadgetDescription;

        public String getGadgetName() {
            return this.gadgetName;
        }

        public void setGadgetName(String name) {
            this.gadgetName = name;
        }

        public String getGadgetUrl() {
            return this.gadgetUrl;
        }

        public void setGadgetUrl(String gadgetUrl) {
            this.gadgetUrl = gadgetUrl;
        }

        public String getGadgetIcon() {
            return this.gadgetIcon;
        }

        public void setGadgetIcon(String gadgetIcon) {
            this.gadgetIcon = gadgetIcon;
        }

        public String getGadgetDescription() {
            return this.gadgetDescription;
        }

        public void setGadgetDescription(String gadgetDescription) {
            this.gadgetDescription = gadgetDescription;
        }
    }

    public static class JsonDashboardInfo {
        String id;
        String label;
        String html;
        String link;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getHtml() {
            return this.html;
        }

        public void setHtml(String html) {
            this.html = html;
        }

        public String getLink() {
            return this.link;
        }

        public void setLink(String link) {
            this.link = link;
        }
    }
}

