/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.control.action;

import java.util.Arrays;
import java.util.List;
import javax.jcr.Node;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.control.UIActionBar;
import org.exoplatform.ecm.webui.component.explorer.control.filter.CanSetPropertyFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsCheckedOutFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsDocumentFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotLockedFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotRootNodeFilter;
import org.exoplatform.ecm.webui.component.explorer.control.listener.UIActionBarActionListener;
import org.exoplatform.ecm.webui.component.explorer.popup.admin.UICategoriesAddedList;
import org.exoplatform.ecm.webui.component.explorer.popup.admin.UICategoryManager;
import org.exoplatform.ecm.webui.tree.selectone.UIOneTaxonomySelector;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(events={@EventConfig(listeners={ManageCategoriesActionListener.class})})
public class ManageCategoriesActionComponent
extends UIComponent {
    private static final List<UIExtensionFilter> FILTERS = Arrays.asList(new UIExtensionFilter[]{new IsNotRootNodeFilter(), new IsCheckedOutFilter(), new CanSetPropertyFilter(), new IsNotLockedFilter(), new IsDocumentFilter()});

    @UIExtensionFilters
    public List<UIExtensionFilter> getFilters() {
        return FILTERS;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ManageCategoriesActionListener
    extends UIActionBarActionListener<ManageCategoriesActionComponent> {
        public void processEvent(Event<ManageCategoriesActionComponent> event) throws Exception {
            UIActionBar uiActionBar = (UIActionBar)((ManageCategoriesActionComponent)((Object)event.getSource())).getAncestorOfType(UIActionBar.class);
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiActionBar.getAncestorOfType(UIJCRExplorer.class);
            String repository = uiExplorer.getRepositoryName();
            String workspaceName = null;
            uiExplorer.setIsHidePopup(true);
            UICategoryManager uiManager = (UICategoryManager)uiExplorer.createUIComponent(UICategoryManager.class, null, null);
            UIOneTaxonomySelector uiOneTaxonomySelector = (UIOneTaxonomySelector)uiManager.getChild(UIOneTaxonomySelector.class);
            TaxonomyService taxonomyService = (TaxonomyService)uiActionBar.getApplicationComponent(TaxonomyService.class);
            UIApplication uiApp = (UIApplication)uiActionBar.getAncestorOfType(UIApplication.class);
            List lstNode = taxonomyService.getAllTaxonomyTrees();
            if (lstNode != null && lstNode.size() > 0) {
                uiOneTaxonomySelector.setRootTaxonomyName(((Node)lstNode.get(0)).getName());
                workspaceName = ((Node)lstNode.get(0)).getSession().getWorkspace().getName();
                uiOneTaxonomySelector.setRootNodeLocation(repository, workspaceName, ((Node)lstNode.get(0)).getPath());
                uiOneTaxonomySelector.setIsDisable(workspaceName, false);
                uiOneTaxonomySelector.setExceptedNodeTypesInPathPanel(new String[]{"exo:symlink"});
                uiOneTaxonomySelector.init(uiExplorer.getSessionProvider());
                UICategoriesAddedList uiCateAddedList = (UICategoriesAddedList)uiManager.getChild(UICategoriesAddedList.class);
                uiOneTaxonomySelector.setSourceComponent((UIComponent)uiCateAddedList, null);
                UIPopupContainer UIPopupContainer2 = (UIPopupContainer)uiExplorer.getChild(UIPopupContainer.class);
                UIPopupContainer2.activate((UIComponent)uiManager, 630, 500);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)UIPopupContainer2);
            } else {
                uiApp.addMessage(new ApplicationMessage("UIActionBar.msg.not-exist-categories", null));
                uiExplorer.updateAjax(event);
            }
        }
    }
}

