/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.wikimodel.xhtml;

import java.util.Stack;
import org.wikimodel.wem.WikiParameter;
import org.wikimodel.wem.WikiParameters;
import org.wikimodel.wem.WikiReference;
import org.wikimodel.wem.xhtml.handler.CommentHandler;
import org.wikimodel.wem.xhtml.impl.XhtmlHandler;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.internal.parser.WikiModelXHTMLParser;
import org.xwiki.rendering.internal.parser.wikimodel.XWikiGeneratorListener;
import org.xwiki.rendering.internal.parser.wikimodel.xhtml.XWikiWikiReference;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.parser.ResourceReferenceParser;
import org.xwiki.rendering.renderer.PrintRenderer;
import org.xwiki.rendering.renderer.PrintRendererFactory;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.renderer.reference.link.URILabelGenerator;
import org.xwiki.xml.XMLUtils;

public class XWikiCommentHandler
extends CommentHandler {
    private static final String COMMENT_SEPARATOR = "|-|";
    private WikiModelXHTMLParser parser;
    private ResourceReferenceParser imageReferenceParser;
    private PrintRendererFactory xwikiSyntaxPrintRendererFactory;
    private ComponentManager componentManager;
    private ResourceReferenceParser xhtmlMarkerResourceReferenceParser;
    private Stack<String> commentContentStack = new Stack();

    public XWikiCommentHandler(ComponentManager componentManager, WikiModelXHTMLParser parser, ResourceReferenceParser imageReferenceParser, PrintRendererFactory xwikiSyntaxPrintRendererFactory, ResourceReferenceParser xhtmlMarkerResourceReferenceParser) {
        this.componentManager = componentManager;
        this.parser = parser;
        this.xwikiSyntaxPrintRendererFactory = xwikiSyntaxPrintRendererFactory;
        this.imageReferenceParser = imageReferenceParser;
        this.xhtmlMarkerResourceReferenceParser = xhtmlMarkerResourceReferenceParser;
    }

    public void onComment(String content, XhtmlHandler.TagStack stack) {
        boolean ignoreElements = (Boolean)stack.getStackParameter("ignoreElements");
        if (!ignoreElements && content.startsWith("startwikilink:")) {
            this.handleLinkCommentStart(XMLUtils.unescapeXMLComment((String)content), stack);
        } else if (!ignoreElements && content.startsWith("stopwikilink")) {
            this.handleLinkCommentStop(XMLUtils.unescapeXMLComment((String)content), stack);
        } else if (!ignoreElements && content.startsWith("startimage:")) {
            this.handleImageCommentStart(XMLUtils.unescapeXMLComment((String)content), stack);
        } else if (!ignoreElements && content.startsWith("stopimage")) {
            this.handleImageCommentStop(XMLUtils.unescapeXMLComment((String)content), stack);
        } else if (!ignoreElements && content.startsWith("startmacro")) {
            super.onComment(XMLUtils.unescapeXMLComment((String)content), stack);
        } else {
            super.onComment(content, stack);
        }
    }

    private void handleLinkCommentStart(String content, XhtmlHandler.TagStack stack) {
        DefaultWikiPrinter printer = new DefaultWikiPrinter();
        PrintRenderer linkLabelRenderer = this.xwikiSyntaxPrintRendererFactory.createRenderer((WikiPrinter)printer);
        linkLabelRenderer.beginDocument(Listener.EMPTY_PARAMETERS);
        XWikiGeneratorListener xwikiListener = this.parser.createXWikiGeneratorListener((Listener)linkLabelRenderer, null);
        stack.pushStackParameter("linkListener", (Object)xwikiListener);
        stack.pushStackParameter("isInLink", (Object)true);
        stack.pushStackParameter("isFreeStandingLink", (Object)false);
        stack.pushStackParameter("linkParameters", (Object)WikiParameters.EMPTY);
        this.commentContentStack.push(content.substring("startwikilink:".length()));
    }

    private void handleLinkCommentStop(String content, XhtmlHandler.TagStack stack) {
        XWikiGeneratorListener xwikiListener = (XWikiGeneratorListener)stack.popStackParameter("linkListener");
        PrintRenderer linkLabelRenderer = (PrintRenderer)xwikiListener.getListener();
        linkLabelRenderer.endDocument(Listener.EMPTY_PARAMETERS);
        boolean isFreeStandingLink = (Boolean)stack.getStackParameter("isFreeStandingLink");
        ResourceReference linkReference = this.xhtmlMarkerResourceReferenceParser.parse(this.commentContentStack.pop());
        WikiParameters linkParams = WikiParameters.EMPTY;
        String label = null;
        if (!isFreeStandingLink) {
            label = linkLabelRenderer.getPrinter().toString();
            linkParams = (WikiParameters)stack.getStackParameter("linkParameters");
        }
        XWikiWikiReference wikiReference = new XWikiWikiReference(linkReference, label, linkParams, isFreeStandingLink);
        stack.getScannerContext().onReference((WikiReference)wikiReference);
        stack.popStackParameter("isInLink");
        stack.popStackParameter("isFreeStandingLink");
        stack.popStackParameter("linkParameters");
    }

    private void handleImageCommentStart(String content, XhtmlHandler.TagStack stack) {
        stack.setStackParameter("isInImage", (Object)true);
        this.commentContentStack.push(content.substring("startimage:".length()));
    }

    private void handleImageCommentStop(String content, XhtmlHandler.TagStack stack) {
        WikiParameter alt;
        boolean isFreeStandingImage = (Boolean)stack.getStackParameter("isFreeStandingImage");
        ResourceReference imageReference = this.xhtmlMarkerResourceReferenceParser.parse(this.commentContentStack.pop());
        WikiParameters imageParams = WikiParameters.EMPTY;
        if (!isFreeStandingImage && (alt = (imageParams = (WikiParameters)stack.getStackParameter("imageParameters")).getParameter("alt")) != null && alt.getValue().equals(this.computeAltAttributeValue(imageReference))) {
            imageParams = imageParams.remove("alt");
        }
        XWikiWikiReference reference = new XWikiWikiReference(imageReference, null, imageParams, isFreeStandingImage);
        stack.getScannerContext().onImage((WikiReference)reference);
        stack.setStackParameter("isInImage", (Object)false);
        stack.setStackParameter("isFreeStandingImage", (Object)false);
        stack.setStackParameter("imageParameters", (Object)WikiParameters.EMPTY);
    }

    private String computeAltAttributeValue(ResourceReference reference) {
        String label;
        try {
            URILabelGenerator uriLabelGenerator = (URILabelGenerator)this.componentManager.lookup(URILabelGenerator.class, reference.getType().getScheme());
            label = uriLabelGenerator.generateLabel(reference);
        }
        catch (ComponentLookupException e) {
            label = reference.getReference();
        }
        return label;
    }
}

