/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest.api;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.service.rest.Util;
import org.exoplatform.social.service.rest.api.models.Version;
import org.exoplatform.social.service.rest.api.models.Versions;

@Path(value="api/social/version")
public class VersionResources
implements ResourceContainer {
    public static final String LATEST_VERSION = "v1-alpha3";
    public static final List<String> SUPPORTED_VERSIONS = new ArrayList<String>();
    private final Log LOG = ExoLogger.getLogger(this.getClass());

    @GET
    @Path(value="latest.{format}")
    public Response getLatestVersion(@Context UriInfo uriInfo, @PathParam(value="format") String format) {
        String[] supportedFormat = new String[]{"json"};
        MediaType mediaType = Util.getMediaType(format, supportedFormat);
        Version entity = new Version();
        entity.setVersion(LATEST_VERSION);
        return Util.getResponse(entity, uriInfo, mediaType, Response.Status.OK);
    }

    @GET
    @Path(value="supported.{format}")
    public Response getSupportedVersions(@Context UriInfo uriInfo, @PathParam(value="format") String format) {
        String[] supportedFormat = new String[]{"json", "xml"};
        Versions entity = new Versions();
        entity.getVersions().addAll(SUPPORTED_VERSIONS);
        return Util.getResponse(entity, uriInfo, Util.getMediaType(format, supportedFormat), Response.Status.OK);
    }

    static {
        SUPPORTED_VERSIONS.add(LATEST_VERSION);
    }
}

