/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.organization;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.naming.InvalidNameException;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.jcr.ext.organization.CommonHandler;
import org.exoplatform.services.jcr.ext.organization.JCROrganizationServiceImpl;
import org.exoplatform.services.jcr.ext.organization.MembershipImpl;
import org.exoplatform.services.jcr.ext.organization.OrganizationServiceException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.CacheHandler;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipEventListener;
import org.exoplatform.services.organization.MembershipEventListenerHandler;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.impl.mock.SimpleMembershipListAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MembershipHandlerImpl
extends CommonHandler
implements MembershipHandler,
MembershipEventListenerHandler {
    public static final String JOS_GROUP = "jos:group";
    public static final String JOS_MEMBERSHIP_TYPE = "jos:membershipType";
    protected final List<MembershipEventListener> listeners = new ArrayList<MembershipEventListener>();
    protected final JCROrganizationServiceImpl service;
    protected static Log log = ExoLogger.getLogger((String)"jcr.MembershipHandlerImpl");

    MembershipHandlerImpl(JCROrganizationServiceImpl service) {
        this.service = service;
    }

    public void addMembershipEventListener(MembershipEventListener listener) {
        this.listeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createMembership(Membership m, boolean broadcast) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            this.createMembership(session, m, broadcast);
        }
        finally {
            session.logout();
        }
    }

    private void createMembership(Session session, Membership m, boolean broadcast) throws Exception, InvalidNameException {
        try {
            if (!session.itemExists(this.service.getStoragePath() + "/" + "jos:users" + "/" + m.getUserName())) {
                throw new InvalidNameException("The user " + m.getUserName() + " not exists");
            }
            if (!session.itemExists(this.service.getStoragePath() + "/" + "jos:groups" + m.getGroupId())) {
                throw new InvalidNameException("The group " + m.getGroupId() + " not exists");
            }
            if (!session.itemExists(this.service.getStoragePath() + "/" + "jos:membershipTypes" + "/" + m.getMembershipType())) {
                throw new InvalidNameException("The membership type " + m.getMembershipType() + " not exists");
            }
            if (this.findMembershipByUserGroupAndType(session, m.getUserName(), m.getGroupId(), m.getMembershipType()) != null) {
                return;
            }
            Node uNode = (Node)session.getItem(this.service.getStoragePath() + "/" + "jos:users" + "/" + m.getUserName());
            Node mNode = uNode.addNode("jos:membership");
            if (m instanceof MembershipImpl) {
                ((MembershipImpl)m).setId(mNode.getUUID());
            }
            if (broadcast) {
                this.preSave(m, true);
            }
            this.writeObjectToNode(session, m, mNode);
            session.save();
            this.service.getCacheHandler().put((Serializable)((Object)this.service.getCacheHandler().getMembershipKey(m)), m, CacheHandler.CacheType.MEMBERSHIP);
            if (broadcast) {
                this.postSave(m, true);
            }
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not create membership record", e);
        }
    }

    public Membership createMembershipInstance() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"createMembershipInstance");
        }
        return new MembershipImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Membership findMembership(String id) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            Membership membership = this.findMembership(session, id);
            return membership;
        }
        finally {
            session.logout();
        }
    }

    private Membership findMembership(Session session, String id) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"findMembership");
        }
        try {
            Node mNode = session.getNodeByUUID(id);
            return this.readObjectFromNode(session, mNode);
        }
        catch (ItemNotFoundException e) {
            throw new OrganizationServiceException("Can not find membership " + id, e);
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not find membership by UUId", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Membership findMembershipByUserGroupAndType(String userName, String groupId, String type) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            Membership membership = this.findMembershipByUserGroupAndType(session, userName, groupId, type);
            return membership;
        }
        finally {
            session.logout();
        }
    }

    private Membership findMembershipByUserGroupAndType(Session session, String userName, String groupId, String type) throws Exception {
        MembershipImpl membership;
        if (log.isDebugEnabled()) {
            log.debug((Object)"findMembershipByUserGroupAndType");
        }
        if ((membership = (MembershipImpl)this.service.getCacheHandler().get((Serializable)((Object)this.service.getCacheHandler().getMembershipKey(userName, groupId, type)), CacheHandler.CacheType.MEMBERSHIP)) != null) {
            return membership;
        }
        try {
            String membershipTypeUUId;
            String groupUUId = this.getGroupUUID(session, groupId);
            if (groupUUId != null && (membershipTypeUUId = this.getMembershipTypeUUID(session, type)) != null) {
                Node uNode = (Node)session.getItem(this.service.getStoragePath() + "/" + "jos:users" + "/" + userName);
                NodeIterator mNodes = uNode.getNodes("jos:membership");
                while (mNodes.hasNext()) {
                    Node mNode = mNodes.nextNode();
                    if (!this.readStringProperty(mNode, JOS_GROUP).equals(groupUUId) || !this.readStringProperty(mNode, JOS_MEMBERSHIP_TYPE).equals(membershipTypeUUId)) continue;
                    if (membership != null) {
                        throw new OrganizationServiceException("More than one membership is found");
                    }
                    membership = new MembershipImpl(mNode.getUUID(), userName, groupId, type);
                }
            }
            if (membership != null) {
                this.service.getCacheHandler().put((Serializable)((Object)this.service.getCacheHandler().getMembershipKey(membership)), membership, CacheHandler.CacheType.MEMBERSHIP);
            }
            return membership;
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not find membership type for user '" + userName + "' groupId '" + groupId + "' type '" + type + "'", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection findMembershipsByGroup(Group group) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            Collection collection = this.findMembershipsByGroup(session, group);
            return collection;
        }
        finally {
            session.logout();
        }
    }

    private Collection findMembershipsByGroup(Session session, Group group) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"findMembershipByGroup");
        }
        try {
            ArrayList<Membership> types = new ArrayList<Membership>();
            String groupUUID = this.getGroupUUID(session, group.getId());
            if (groupUUID != null) {
                String statement = "select * from jos:userMembership where jos:group='" + groupUUID + "'";
                Query mQuery = session.getWorkspace().getQueryManager().createQuery(statement, "sql");
                QueryResult mRes = mQuery.execute();
                NodeIterator mNodes = mRes.getNodes();
                while (mNodes.hasNext()) {
                    types.add(this.readObjectFromNode(session, mNodes.nextNode()));
                }
            }
            return types;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not find membership by group", e);
        }
    }

    public ListAccess<Membership> findAllMembershipsByGroup(Group group) throws Exception {
        return new SimpleMembershipListAccess(this.findMembershipsByGroup(group));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection findMembershipsByUser(String userName) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            Collection collection = this.findMembershipsByUser(session, userName);
            return collection;
        }
        finally {
            session.logout();
        }
    }

    private Collection findMembershipsByUser(Session session, String userName) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"findMembeshipByUser");
        }
        ArrayList<Membership> types = new ArrayList<Membership>();
        try {
            Node uNode = (Node)session.getItem(this.service.getStoragePath() + "/" + "jos:users" + "/" + userName);
            NodeIterator mNodes = uNode.getNodes("jos:membership");
            while (mNodes.hasNext()) {
                types.add(this.readObjectFromNode(session, mNodes.nextNode()));
            }
            return types;
        }
        catch (PathNotFoundException e) {
            return types;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not find membership by user '" + userName + "'", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection findMembershipsByUserAndGroup(String userName, String groupId) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            Collection collection = this.findMembershipsByUserAndGroup(session, userName, groupId);
            return collection;
        }
        finally {
            session.logout();
        }
    }

    private Collection findMembershipsByUserAndGroup(Session session, String userName, String groupId) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"findMembershipByUserAndGroup");
        }
        ArrayList<Membership> types = new ArrayList<Membership>();
        try {
            String groupUUId = this.getGroupUUID(session, groupId);
            if (groupUUId != null) {
                Node uNode = (Node)session.getItem(this.service.getStoragePath() + "/" + "jos:users" + "/" + userName);
                NodeIterator mNodes = uNode.getNodes("jos:membership");
                while (mNodes.hasNext()) {
                    Node mNode = mNodes.nextNode();
                    if (!this.readStringProperty(mNode, JOS_GROUP).equals(groupUUId)) continue;
                    types.add(this.readObjectFromNode(session, mNode));
                }
            }
            return types;
        }
        catch (PathNotFoundException e) {
            return types;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not find membership by user '" + userName + "' and group '" + groupId + "'", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void linkMembership(User user, Group group, MembershipType m, boolean broadcast) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            this.linkMembership(session, user, group, m, broadcast);
        }
        finally {
            session.logout();
        }
    }

    private void linkMembership(Session session, User user, Group group, MembershipType m, boolean broadcast) throws Exception {
        try {
            if (user == null) {
                throw new InvalidNameException("Can not create membership record because user is null");
            }
            if (group == null) {
                throw new InvalidNameException("Can not create membership record for " + user.getUserName() + " because group is null");
            }
            if (m == null) {
                throw new InvalidNameException("Can not create membership record for " + user.getUserName() + " because membership type is null");
            }
            MembershipImpl membership = new MembershipImpl(null, user.getUserName(), group.getId(), m.getName());
            this.createMembership(session, membership, broadcast);
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not link membership for user '" + user.getUserName(), e);
        }
    }

    Membership removeMembership(Session session, String id, boolean broadcast) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"removeMembership");
        }
        try {
            Node mNode = session.getNodeByUUID(id);
            Membership membership = this.readObjectFromNode(session, mNode);
            if (broadcast) {
                this.preDelete(membership);
            }
            mNode.remove();
            session.save();
            this.service.getCacheHandler().remove((Serializable)((Object)this.service.getCacheHandler().getMembershipKey(membership)), CacheHandler.CacheType.MEMBERSHIP);
            if (broadcast) {
                this.postDelete(membership);
            }
            return membership;
        }
        catch (ItemNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not remove membership", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Membership removeMembership(String id, boolean broadcast) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            Membership membership = this.removeMembership(session, id, broadcast);
            return membership;
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection removeMembershipByUser(String userName, boolean broadcast) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            Collection collection = this.removeMembershipByUser(session, userName, broadcast);
            return collection;
        }
        finally {
            session.logout();
        }
    }

    private Collection removeMembershipByUser(Session session, String userName, boolean broadcast) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"removeMembershipByUser");
        }
        ArrayList<Membership> types = new ArrayList<Membership>();
        try {
            Node uNode = (Node)session.getItem(this.service.getStoragePath() + "/" + "jos:users" + "/" + userName);
            NodeIterator mNodes = uNode.getNodes("jos:membership");
            while (mNodes.hasNext()) {
                Node mNode = mNodes.nextNode();
                Membership membership = this.readObjectFromNode(session, mNode);
                types.add(membership);
                if (broadcast) {
                    this.preDelete(membership);
                }
                mNode.remove();
            }
            session.save();
            this.service.getCacheHandler().remove((Serializable)((Object)("u=" + userName)), CacheHandler.CacheType.MEMBERSHIP);
            for (int i = 0; i < types.size(); ++i) {
                if (!broadcast) continue;
                this.postDelete((Membership)types.get(i));
            }
            return types;
        }
        catch (PathNotFoundException e) {
            return types;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not remove membership by user '" + userName + "'", e);
        }
    }

    public void removeMembershipEventListener(MembershipEventListener listener) {
        this.listeners.remove(listener);
    }

    private String getMembershipTypeUUID(Session session, String type) throws Exception {
        try {
            String mtPath = this.service.getStoragePath() + "/" + "jos:membershipTypes";
            return type != null && type.length() != 0 && session.itemExists(mtPath + "/" + type) ? ((Node)session.getItem(mtPath + "/" + type)).getUUID() : null;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not find membership type '" + type + "'", e);
        }
    }

    private String getGroupUUID(Session session, String groupId) throws Exception {
        try {
            String gPath = this.service.getStoragePath() + "/" + "jos:groups";
            return groupId != null && groupId.length() != 0 && session.itemExists(gPath + groupId) ? ((Node)session.getItem(gPath + groupId)).getUUID() : null;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not find group '" + groupId + "'", e);
        }
    }

    private String getMembershipType(Session session, String UUID) throws Exception {
        try {
            return session.getNodeByUUID(UUID).getName();
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not find membership type by uuid " + UUID, e);
        }
    }

    private String getGroupId(Session session, String UUID) throws Exception {
        try {
            Node gNode = session.getNodeByUUID(UUID);
            return this.readStringProperty(gNode, "jos:groupId");
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not find group by uuid " + UUID, e);
        }
    }

    private Membership readObjectFromNode(Session session, Node node) throws Exception {
        try {
            String groupUUID = this.readStringProperty(node, JOS_GROUP);
            String membershipTypeUUID = this.readStringProperty(node, JOS_MEMBERSHIP_TYPE);
            String groupId = this.getGroupId(session, groupUUID);
            String membershipType = this.getMembershipType(session, membershipTypeUUID);
            String userName = node.getParent().getName();
            return new MembershipImpl(node.getUUID(), userName, groupId, membershipType);
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not read membership properties", e);
        }
    }

    private void writeObjectToNode(Session session, Membership m, Node node) throws Exception {
        try {
            String groupUUId = this.getGroupUUID(session, m.getGroupId());
            String membershipTypeUUId = this.getMembershipTypeUUID(session, m.getMembershipType());
            node.setProperty(JOS_GROUP, groupUUId);
            node.setProperty(JOS_MEMBERSHIP_TYPE, membershipTypeUUId);
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not write membership properties", e);
        }
    }

    private void preSave(Membership membership, boolean isNew) throws Exception {
        for (int i = 0; i < this.listeners.size(); ++i) {
            MembershipEventListener listener = this.listeners.get(i);
            listener.preSave(membership, isNew);
        }
    }

    private void postSave(Membership membership, boolean isNew) throws Exception {
        for (int i = 0; i < this.listeners.size(); ++i) {
            MembershipEventListener listener = this.listeners.get(i);
            listener.postSave(membership, isNew);
        }
    }

    private void preDelete(Membership membership) throws Exception {
        for (int i = 0; i < this.listeners.size(); ++i) {
            MembershipEventListener listener = this.listeners.get(i);
            listener.preDelete(membership);
        }
    }

    private void postDelete(Membership membership) throws Exception {
        for (int i = 0; i < this.listeners.size(); ++i) {
            MembershipEventListener listener = this.listeners.get(i);
            listener.postDelete(membership);
        }
    }

    public List<MembershipEventListener> getMembershipListeners() {
        return Collections.unmodifiableList(this.listeners);
    }
}

