/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.extras.migration.io;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.exoplatform.social.extras.migration.io.NodeData;

public class NodeStreamHandler {
    public void writeNode(Node node, OutputStream os) throws RepositoryException, IOException {
        DataOutputStream dos = new DataOutputStream(os);
        dos.writeInt(1);
        dos.writeUTF(node.getPath());
        PropertyIterator it = node.getProperties();
        while (it.hasNext()) {
            Property p = it.nextProperty();
            if (p.getDefinition().isMultiple()) {
                dos.writeInt(3);
                dos.writeInt(p.getValues().length);
                dos.writeUTF(p.getName());
                for (Value v : p.getValues()) {
                    dos.writeUTF(v.getString());
                }
                continue;
            }
            dos.writeInt(2);
            dos.writeUTF(p.getName());
            dos.writeUTF(p.getString());
        }
        dos.writeInt(4);
        dos.flush();
    }

    public NodeData readNode(InputStream is) {
        NodeData data = new NodeData();
        DataInputStream dis = new DataInputStream(is);
        try {
            while (this.readData(dis, data) != 4) {
            }
        }
        catch (IOException e) {
            return null;
        }
        return data;
    }

    private int readData(DataInputStream dis, NodeData data) throws IOException {
        int type = dis.readInt();
        switch (type) {
            case 1: {
                data.setPath(dis.readUTF());
                break;
            }
            case 2: {
                data.put(dis.readUTF(), dis.readUTF());
                break;
            }
            case 3: {
                int length = dis.readInt();
                String[] values = new String[length];
                String propertyName = dis.readUTF();
                for (int i = 0; i < length; ++i) {
                    values[i] = dis.readUTF();
                }
                data.put(propertyName, values);
                break;
            }
        }
        return type;
    }
}

