/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.connection.impl;

import com.sun.mail.util.MailSSLSocketFactory;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;
import org.exoplatform.mail.connection.Connector;
import org.exoplatform.mail.service.Account;

public abstract class BaseConnector
implements Connector {
    protected Store store_;
    protected Account account_;

    public abstract Session getSession(Account var1, MailSSLSocketFactory var2) throws MessagingException;

    public boolean isConnected() {
        return this.store_ != null && this.store_.isConnected();
    }

    public void openStore(Account account) throws MessagingException {
        if (this.store_ == null) {
            return;
        }
        this.account_ = account;
        this.store_.connect(account.getIncomingHost(), Integer.valueOf(account.getIncomingPort()).intValue(), account.getIncomingUser(), account.getIncomingPassword());
    }

    public Store getStore() {
        return this.store_;
    }

    public Account getAccount() {
        return this.account_;
    }

    public Folder getDefaultFolder() throws MessagingException {
        return this.store_.getDefaultFolder();
    }

    public Folder getFolder(String folderUrl) throws MessagingException {
        return this.store_.getFolder(new URLName(folderUrl));
    }

    public Folder getFolder(URLName folderUrl) throws MessagingException {
        return this.store_.getFolder(folderUrl);
    }

    public void close() {
        if (this.store_ != null) {
            try {
                this.store_.close();
            }
            catch (MessagingException messagingException) {
                // empty catch block
            }
        }
    }
}

