/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ide.groovy.codeassistant;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.ide.groovy.JcrUtils;
import org.exoplatform.ide.groovy.codeassistant.CodeAssistantException;
import org.exoplatform.ide.groovy.codeassistant.bean.ShortTypeInfo;
import org.exoplatform.ide.groovy.codeassistant.bean.TypeInfo;
import org.exoplatform.ide.groovy.codeassistant.extractors.GroovyClassNamesExtractor;
import org.exoplatform.ide.groovy.util.DependentResources;
import org.exoplatform.ide.groovy.util.GroovyScriptServiceUtil;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.ext.app.ThreadLocalSessionProviderService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.ws.frameworks.json.JsonHandler;
import org.exoplatform.ws.frameworks.json.impl.JsonDefaultHandler;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.exoplatform.ws.frameworks.json.impl.JsonParserImpl;
import org.exoplatform.ws.frameworks.json.impl.ObjectBuilder;
import org.exoplatform.ws.frameworks.json.value.JsonValue;

@Path(value="/ide/code-assistant")
public class CodeAssistant {
    private final RepositoryService repositoryService;
    private final ThreadLocalSessionProviderService sessionProviderService;
    private final String wsName;
    private static final Log LOG = ExoLogger.getLogger(CodeAssistant.class);

    public CodeAssistant(String wsName, RepositoryService repositoryService, ThreadLocalSessionProviderService sessionProviderService) {
        this.repositoryService = repositoryService;
        this.sessionProviderService = sessionProviderService;
        this.wsName = wsName;
    }

    @GET
    @Path(value="/class-description")
    @Produces(value={"application/json"})
    public TypeInfo getClassByFQN(@Context UriInfo uriInfo, @QueryParam(value="fqn") String fqn, @HeaderParam(value="location") String location) throws CodeAssistantException {
        String sql = "SELECT * FROM exoide:classDescription WHERE exoide:fqn='" + fqn + "'";
        try {
            DependentResources dependentResources;
            Session session = JcrUtils.getSession(this.repositoryService, this.sessionProviderService, this.wsName);
            Query q = session.getWorkspace().getQueryManager().createQuery(sql, "sql");
            QueryResult result = q.execute();
            NodeIterator nodes = result.getNodes();
            if (nodes.hasNext()) {
                Node node = (Node)nodes.next();
                JsonParserImpl jsonParser = new JsonParserImpl();
                JsonDefaultHandler jsonHandler = new JsonDefaultHandler();
                jsonParser.parse(node.getProperty("jcr:data").getStream(), (JsonHandler)jsonHandler);
                JsonValue jsonValue = jsonHandler.getJsonObject();
                TypeInfo typeInfo = (TypeInfo)ObjectBuilder.createObject(TypeInfo.class, (JsonValue)jsonValue);
                return typeInfo;
            }
            if (location != null && (dependentResources = GroovyScriptServiceUtil.getDependentResource(location, uriInfo.getBaseUri().toASCIIString(), this.repositoryService, this.sessionProviderService)) != null) {
                TypeInfo classInfo = new GroovyClassNamesExtractor(this.repositoryService, this.sessionProviderService).getClassInfo(fqn, dependentResources);
                if (classInfo == null) {
                    throw new CodeAssistantException(404, "Class info for " + fqn + " not found");
                }
                return classInfo;
            }
            if (LOG.isDebugEnabled()) {
                LOG.error((Object)("Class info for " + fqn + " not found"));
            }
            return null;
        }
        catch (RepositoryException e) {
            if (LOG.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new CodeAssistantException(404, e.getMessage());
        }
        catch (RepositoryConfigurationException e) {
            if (LOG.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new CodeAssistantException(404, e.getMessage());
        }
        catch (JsonException e) {
            if (LOG.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new CodeAssistantException(500, e.getMessage());
        }
        catch (MalformedURLException e) {
            if (LOG.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new CodeAssistantException(500, e.getMessage());
        }
        catch (URISyntaxException e) {
            if (LOG.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new CodeAssistantException(500, e.getMessage());
        }
    }

    @GET
    @Path(value="/find")
    @Produces(value={"application/json"})
    public List<ShortTypeInfo> findFQNsByClassName(@Context UriInfo uriInfo, @QueryParam(value="class") String className, @HeaderParam(value="location") String location) throws CodeAssistantException {
        List<ShortTypeInfo> types = new ArrayList<ShortTypeInfo>();
        String sql = "SELECT * FROM exoide:classDescription WHERE exoide:className='" + className + "'";
        try {
            DependentResources dependentResources;
            if (location != null && !location.isEmpty() && (dependentResources = GroovyScriptServiceUtil.getDependentResource(location, uriInfo.getBaseUri().toASCIIString(), this.repositoryService, this.sessionProviderService)) != null) {
                types = new GroovyClassNamesExtractor(this.repositoryService, this.sessionProviderService).getClassNames(className, dependentResources);
            }
            Session session = JcrUtils.getSession(this.repositoryService, this.sessionProviderService, this.wsName);
            Query q = session.getWorkspace().getQueryManager().createQuery(sql, "sql");
            QueryResult result = q.execute();
            NodeIterator nodes = result.getNodes();
            while (nodes.hasNext()) {
                Node node = (Node)nodes.next();
                types.add(new ShortTypeInfo((int)node.getProperty("exoide:modifieres").getLong(), node.getProperty("exoide:className").getString(), node.getProperty("exoide:fqn").getString(), node.getProperty("exoide:type").getString()));
            }
            return types;
        }
        catch (RepositoryException e) {
            if (LOG.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new CodeAssistantException(404, e.getMessage());
        }
        catch (RepositoryConfigurationException e) {
            if (LOG.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new CodeAssistantException(404, e.getMessage());
        }
        catch (MalformedURLException e) {
            if (LOG.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new CodeAssistantException(400, e.getMessage());
        }
        catch (URISyntaxException e) {
            if (LOG.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new CodeAssistantException(400, e.getMessage());
        }
    }

    @GET
    @Path(value="/find-by-prefix/{prefix}")
    @Produces(value={"application/json"})
    public List<ShortTypeInfo> findFQNsByPrefix(@Context UriInfo uriInfo, @PathParam(value="prefix") String prefix, @QueryParam(value="where") String where, @HeaderParam(value="location") String location) throws CodeAssistantException {
        List<ShortTypeInfo> groovyClass = null;
        ShortTypeInfo[] types = null;
        if (where == null || "".equals(where)) {
            where = "className";
        } else if (!"className".equals(where) && !"fqn".equals(where)) {
            throw new CodeAssistantException(400, "\"where\" parameter must be className or fqn");
        }
        String sql = "SELECT * FROM exoide:classDescription WHERE exoide:" + where + " LIKE '" + prefix + "%'";
        try {
            DependentResources dependentResources;
            if (location != null && !location.isEmpty() && where.equals("className") && (dependentResources = GroovyScriptServiceUtil.getDependentResource(location, uriInfo.getBaseUri().toASCIIString(), this.repositoryService, this.sessionProviderService)) != null) {
                groovyClass = new GroovyClassNamesExtractor(this.repositoryService, this.sessionProviderService).getClassNames(prefix, dependentResources);
            }
            Session session = JcrUtils.getSession(this.repositoryService, this.sessionProviderService, this.wsName);
            Query q = session.getWorkspace().getQueryManager().createQuery(sql, "sql");
            QueryResult result = q.execute();
            NodeIterator nodes = result.getNodes();
            types = new ShortTypeInfo[(int)nodes.getSize()];
            int i = 0;
            while (nodes.hasNext()) {
                Node node = (Node)nodes.next();
                types[i++] = new ShortTypeInfo(0, node.getProperty("exoide:className").getString(), node.getProperty("exoide:fqn").getString(), node.getProperty("exoide:type").getString());
            }
        }
        catch (RepositoryException e) {
            if (LOG.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new CodeAssistantException(404, e.getMessage());
        }
        catch (RepositoryConfigurationException e) {
            if (LOG.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new CodeAssistantException(404, e.getMessage());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        ArrayList<ShortTypeInfo> result = new ArrayList<ShortTypeInfo>();
        if (types != null) {
            result.addAll(Arrays.asList(types));
        }
        if (groovyClass != null) {
            result.addAll(groovyClass);
        }
        return result;
    }

    @GET
    @Path(value="/find-by-type/{type}")
    @Produces(value={"application/json"})
    public ShortTypeInfo[] findByType(@PathParam(value="type") String type, @QueryParam(value="prefix") String prefix) throws CodeAssistantException {
        String sql = "SELECT * FROM exoide:classDescription WHERE exoide:type = '" + type.toUpperCase() + "'";
        if (prefix != null && !prefix.isEmpty()) {
            sql = sql + " AND exoide:className LIKE '" + prefix + "%'";
        }
        try {
            Session session = JcrUtils.getSession(this.repositoryService, this.sessionProviderService, this.wsName);
            Query q = session.getWorkspace().getQueryManager().createQuery(sql, "sql");
            QueryResult result = q.execute();
            NodeIterator nodes = result.getNodes();
            ShortTypeInfo[] types = new ShortTypeInfo[(int)nodes.getSize()];
            int i = 0;
            while (nodes.hasNext()) {
                Node node = (Node)nodes.next();
                types[i++] = new ShortTypeInfo(0, node.getProperty("exoide:className").getString(), node.getProperty("exoide:fqn").getString(), node.getProperty("exoide:type").getString());
            }
            return types;
        }
        catch (RepositoryException e) {
            if (LOG.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new CodeAssistantException(404, e.getMessage());
        }
        catch (RepositoryConfigurationException e) {
            if (LOG.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new CodeAssistantException(404, e.getMessage());
        }
    }

    @GET
    @Path(value="/class-doc")
    @Produces(value={"text/html"})
    public String getClassDoc(@QueryParam(value="fqn") String fqn) throws CodeAssistantException {
        String sql = "SELECT * FROM exoide:javaDoc WHERE exoide:fqn='" + fqn + "'";
        try {
            Session session = JcrUtils.getSession(this.repositoryService, this.sessionProviderService, this.wsName);
            Query q = session.getWorkspace().getQueryManager().createQuery(sql, "sql");
            QueryResult result = q.execute();
            NodeIterator nodes = result.getNodes();
            String doc = new String();
            if (nodes.getSize() == 0L) {
                throw new CodeAssistantException(404, "Not found");
            }
            while (nodes.hasNext()) {
                Node node = (Node)nodes.next();
                doc = node.getProperty("jcr:data").getString();
            }
            doc = doc.replaceAll("[ ]+\\*", "");
            return "<html><head></head><body style=\"font-family: monospace;font-size: 12px;\">" + doc + "</body></html>";
        }
        catch (RepositoryException e) {
            if (LOG.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new CodeAssistantException(404, e.getMessage());
        }
        catch (RepositoryConfigurationException e) {
            if (LOG.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new CodeAssistantException(404, e.getMessage());
        }
    }
}

