/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ide.filter;

import java.io.IOException;
import java.net.URLEncoder;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class MakeRequestHeaderFilter
implements Filter {
    private final String HEADERS_PARAMETER = "headers";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String cookie = httpRequest.getHeader("Cookie");
        if (cookie == null) {
            chain.doFilter((ServletRequest)httpRequest, response);
            return;
        }
        String headers = httpRequest.getParameter("headers");
        String cookieHeader = "Cookie=" + URLEncoder.encode(cookie, "UTF-8");
        cookieHeader = headers == null || headers.length() <= 0 ? cookieHeader : "&" + cookieHeader;
        headers = headers + cookieHeader;
        RequestWrapper requestWrapper = new RequestWrapper(httpRequest, headers);
        chain.doFilter((ServletRequest)requestWrapper, response);
    }

    public void destroy() {
    }

    private class RequestWrapper
    extends HttpServletRequestWrapper {
        private String headersParameter;

        public RequestWrapper(HttpServletRequest request, String headersParameter) {
            super(request);
            this.headersParameter = headersParameter;
        }

        public String getParameter(String name) {
            if (name.equals("headers") && this.headersParameter != null) {
                return this.headersParameter;
            }
            return super.getParameter(name);
        }
    }
}

