/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.admin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.MissingResourceException;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.popup.admin.UICategoryManager;
import org.exoplatform.ecm.webui.component.explorer.popup.admin.UISimpleCategoryManager;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.ecm.webui.tree.selectone.UIOneNodePathSelector;
import org.exoplatform.ecm.webui.tree.selectone.UIOneTaxonomySelector;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.publication.WCMComposer;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.exception.MessageException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/webui/component/explorer/popup/admin/UICategoriesAddedList.gtmpl", events={@EventConfig(listeners={DeleteActionListener.class}, confirm="UICategoriesAddedList.msg.confirm-delete")})
public class UICategoriesAddedList
extends UIContainer
implements UISelectable {
    private UIPageIterator uiPageIterator_ = (UIPageIterator)this.addChild(UIPageIterator.class, null, "CategoriesAddedList");
    private static final Log LOG = ExoLogger.getLogger(UICategoriesAddedList.class);

    public UIPageIterator getUIPageIterator() {
        return this.uiPageIterator_;
    }

    public List getListCategories() throws Exception {
        return NodeLocation.getNodeListByLocationList((List)this.uiPageIterator_.getCurrentPageData());
    }

    public void updateGrid(int currentPage) throws Exception {
        ListAccessImpl categoryList = new ListAccessImpl(Object.class, NodeLocation.getLocationsByNodeList(this.getCategories()));
        LazyPageList objPageList = new LazyPageList((ListAccess)categoryList, 10);
        this.uiPageIterator_.setPageList((PageList)objPageList);
        if (currentPage > this.getUIPageIterator().getAvailablePage()) {
            this.getUIPageIterator().setCurrentPage(this.getUIPageIterator().getAvailablePage());
        } else {
            this.getUIPageIterator().setCurrentPage(currentPage);
        }
    }

    public List<Node> getCategories() throws Exception {
        ArrayList<Node> listCategories = new ArrayList<Node>();
        UIJCRExplorer uiJCRExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        TaxonomyService taxonomyService = (TaxonomyService)this.getApplicationComponent(TaxonomyService.class);
        List<Node> listNode = this.getAllTaxonomyTrees();
        for (Node itemNode : listNode) {
            listCategories.addAll(taxonomyService.getCategories(uiJCRExplorer.getCurrentNode(), itemNode.getName()));
        }
        return listCategories;
    }

    List<Node> getAllTaxonomyTrees() throws RepositoryException {
        TaxonomyService taxonomyService = (TaxonomyService)this.getApplicationComponent(TaxonomyService.class);
        return taxonomyService.getAllTaxonomyTrees();
    }

    String displayCategory(Node node, List<Node> taxonomyTrees) {
        try {
            for (Node taxonomyTree : taxonomyTrees) {
                if (!node.getPath().contains(taxonomyTree.getPath())) continue;
                return this.getCategoryLabel(node.getPath().replace(taxonomyTree.getPath(), taxonomyTree.getName()));
            }
        }
        catch (RepositoryException e) {
            LOG.error((Object)"Unexpected error when ");
        }
        return "";
    }

    private String getCategoryLabel(String resource) {
        String[] taxonomyPathSplit = resource.split("/");
        StringBuilder buildPathlabel = new StringBuilder();
        for (int i = 0; i < taxonomyPathSplit.length; ++i) {
            StringBuilder buildlabel = new StringBuilder("eXoTaxonomies");
            for (int j = 0; j <= i; ++j) {
                buildlabel.append(".").append(taxonomyPathSplit[j]);
            }
            try {
                buildPathlabel.append(Utils.getResourceBundle((String)buildlabel.append(".label").toString())).append("/");
                continue;
            }
            catch (MissingResourceException me) {
                buildPathlabel.append(taxonomyPathSplit[i]).append("/");
            }
        }
        return buildPathlabel.substring(0, buildPathlabel.length() - 1);
    }

    public void doSelect(String selectField, Object value) throws Exception {
        String rootTaxonomyName;
        UIJCRExplorer uiJCRExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        UICategoryManager uiCategoryManager = (UICategoryManager)this.getAncestorOfType(UICategoryManager.class);
        if (uiCategoryManager == null) {
            UISimpleCategoryManager uiSimpleCategoryManager = (UISimpleCategoryManager)this.getAncestorOfType(UISimpleCategoryManager.class);
            UIOneNodePathSelector uiNodePathSelector = (UIOneNodePathSelector)uiSimpleCategoryManager.getChild(UIOneNodePathSelector.class);
            rootTaxonomyName = uiNodePathSelector.getRootTaxonomyName();
        } else {
            UIOneTaxonomySelector uiOneTaxonomySelector = (UIOneTaxonomySelector)uiCategoryManager.getChild(UIOneTaxonomySelector.class);
            rootTaxonomyName = uiOneTaxonomySelector.getRootTaxonomyName();
        }
        TaxonomyService taxonomyService = (TaxonomyService)this.getApplicationComponent(TaxonomyService.class);
        try {
            Node currentNode = uiJCRExplorer.getCurrentNode();
            uiJCRExplorer.addLockToken(currentNode);
            if (rootTaxonomyName.equals(value)) {
                taxonomyService.addCategory(currentNode, rootTaxonomyName, "");
            } else {
                String[] arrayCategoryPath = String.valueOf(value.toString()).split("/");
                StringBuffer categoryPath = new StringBuffer().append("/");
                for (int i = 1; i < arrayCategoryPath.length; ++i) {
                    categoryPath.append(arrayCategoryPath[i]);
                    categoryPath.append("/");
                }
                taxonomyService.addCategory(currentNode, rootTaxonomyName, categoryPath.toString());
            }
            uiJCRExplorer.getCurrentNode().save();
            uiJCRExplorer.getSession().save();
            this.updateGrid(1);
            this.setRenderSibling(UICategoriesAddedList.class);
            NodeLocation location = NodeLocation.getNodeLocationByNode((Node)currentNode);
            WCMComposer composer = (WCMComposer)WCMCoreUtils.getService(WCMComposer.class);
            composer.updateContent(location.getWorkspace(), location.getPath(), new HashMap());
        }
        catch (AccessDeniedException accessDeniedException) {
            throw new MessageException(new ApplicationMessage("AccessControlException.msg", null, 1));
        }
        catch (ItemExistsException item) {
            throw new MessageException(new ApplicationMessage("UICategoriesAddedList.msg.ItemExistsException", null, 1));
        }
        catch (Exception e) {
            LOG.error((Object)"Unexpected error", (Throwable)e);
            JCRExceptionManager.process((UIApplication)((UIApplication)this.getAncestorOfType(UIApplication.class)), (Exception)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteActionListener
    extends EventListener<UICategoriesAddedList> {
        public void execute(Event<UICategoriesAddedList> event) throws Exception {
            UICategoriesAddedList uiAddedList = (UICategoriesAddedList)((Object)event.getSource());
            UIContainer uiManager = (UIContainer)uiAddedList.getParent();
            UIApplication uiApp = (UIApplication)uiAddedList.getAncestorOfType(UIApplication.class);
            String nodePath = event.getRequestContext().getRequestParameter("objectId");
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiAddedList.getAncestorOfType(UIJCRExplorer.class);
            WCMComposer composer = (WCMComposer)WCMCoreUtils.getService(WCMComposer.class);
            Node currentNode = uiExplorer.getCurrentNode();
            TaxonomyService taxonomyService = (TaxonomyService)uiAddedList.getApplicationComponent(TaxonomyService.class);
            List categories = taxonomyService.getAllCategories(currentNode);
            try {
                List<Node> listNode = uiAddedList.getAllTaxonomyTrees();
                for (Node itemNode : listNode) {
                    if (!nodePath.contains(itemNode.getPath())) continue;
                    taxonomyService.removeCategory(currentNode, itemNode.getName(), nodePath.substring(itemNode.getPath().length()));
                    break;
                }
                uiAddedList.updateGrid(uiAddedList.getUIPageIterator().getCurrentPage());
                for (Node catnode : categories) {
                    composer.updateContents(catnode.getSession().getWorkspace().getName(), catnode.getPath(), new HashMap());
                }
            }
            catch (AccessDeniedException ace) {
                throw new MessageException(new ApplicationMessage("UICategoriesAddedList.msg.access-denied", null, 1));
            }
            catch (Exception e) {
                LOG.error((Object)"Unexpected error", (Throwable)e);
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            }
            uiManager.setRenderedChild("UICategoriesAddedList");
        }
    }
}

