/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.splashscreen;

import com.exe4j.runtime.util.ResourceHelper;
import com.install4j.runtime.splashscreen.SplashScreenConfig;
import com.install4j.runtime.splashscreen.TextLineConfig;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class JavaSplashScreen
extends Window {
    private JLabel lblStatus;
    private JLabel lblVersion;
    private JLabel lblSplash;

    public JavaSplashScreen(SplashScreenConfig splashScreenConfig, boolean bl) {
        super(new Frame());
        if (splashScreenConfig.isAlwaysOnTop()) {
            this.makeAlwaysOnTop();
        }
        ImageIcon imageIcon = new ImageIcon(ResourceHelper.getImageURL(splashScreenConfig.getBitmapName()));
        this.layout(imageIcon, splashScreenConfig.getStatusLineConfig(), splashScreenConfig.getVersionLineConfig(), bl);
    }

    private void makeAlwaysOnTop() {
        this.addWindowListener(new WindowAdapter(){

            public void windowDeactivated(WindowEvent windowEvent) {
                JavaSplashScreen.this.toFront();
            }
        });
    }

    private void layout(Icon icon, TextLineConfig textLineConfig, TextLineConfig textLineConfig2, boolean bl) {
        Serializable serializable;
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(null);
        this.lblStatus = JavaSplashScreen.createLabel(textLineConfig);
        jPanel.add(this.lblStatus);
        this.lblVersion = JavaSplashScreen.createLabel(textLineConfig2);
        jPanel.add(this.lblVersion);
        this.lblSplash = new JLabel(icon);
        Rectangle rectangle = new Rectangle(new Point(0, 0), this.lblSplash.getPreferredSize());
        this.lblSplash.setBounds(rectangle);
        jPanel.add(this.lblSplash);
        this.add((Component)jPanel, "Center");
        int n = this.lblSplash.getPreferredSize().width;
        int n2 = this.lblSplash.getPreferredSize().height;
        if (bl) {
            serializable = new Font(null, 1, 12);
            JLabel jLabel = new JLabel("This executable was created with");
            JLabel jLabel2 = new JLabel("an evaluation version of install4j.");
            jLabel.setFont((Font)serializable);
            jLabel2.setFont((Font)serializable);
            jLabel.setForeground(Color.red);
            jLabel2.setForeground(Color.red);
            jLabel.setHorizontalAlignment(0);
            jLabel2.setHorizontalAlignment(0);
            JPanel jPanel2 = new JPanel(new GridLayout(2, 0, 3, 3));
            jPanel2.add(jLabel);
            jPanel2.add(jLabel2);
            jPanel2.setBackground(Color.lightGray);
            jPanel2.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            this.add((Component)jPanel2, "South");
            n2 += jPanel2.getPreferredSize().height;
            n = Math.max(n, jPanel2.getPreferredSize().width);
        }
        serializable = Toolkit.getDefaultToolkit().getScreenSize();
        int n3 = (serializable.width - n) / 2;
        int n4 = (serializable.height - n2) / 2;
        this.setBounds(n3, n4, n, n2);
    }

    private static JLabel createLabel(TextLineConfig textLineConfig) {
        JLabel jLabel = new JLabel(textLineConfig.getText());
        jLabel.setOpaque(false);
        jLabel.setForeground(textLineConfig.getFontColor());
        Font font = jLabel.getFont();
        jLabel.setFont(font.deriveFont(textLineConfig.getFontStyle(), (int)((double)textLineConfig.getFontSize() * 1.2)));
        Rectangle rectangle = new Rectangle(textLineConfig.getPosition(), new Dimension(600, jLabel.getPreferredSize().height));
        jLabel.setBounds(rectangle);
        return jLabel;
    }

    public void setMessage(String string) {
        this.lblStatus.setText(string);
    }
}

