/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.processes.publishing;

import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.processes.publishing.ProcessUtil;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

public class InitialActionHandler
implements ActionHandler {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = ExoLogger.getLogger(InitialActionHandler.class);

    public void execute(ExecutionContext context) throws Exception {
        this.initialVariables(context);
        ProcessUtil.requestForValidation((ExecutionContext)context);
    }

    protected void initialVariables(ExecutionContext context) throws Exception {
        Node actionNode;
        String actionName = (String)context.getVariable("actionName");
        String nodePath = (String)context.getVariable("nodePath");
        String srcPath = (String)context.getVariable("srcPath");
        String srcWorkspace = (String)context.getVariable("srcWorkspace");
        ContextInstance contextInstance = context.getContextInstance();
        contextInstance.setVariable("exocontainer", (Object)((PortalContainer)ExoContainerContext.getCurrentContainer()).getName());
        ProcessUtil.setCurrentLocation((ExecutionContext)context, (String)srcWorkspace, (String)nodePath);
        RepositoryService repositoryService = (RepositoryService)ProcessUtil.getService((ExecutionContext)context, RepositoryService.class);
        ActionServiceContainer actionServiceContainer = (ActionServiceContainer)ProcessUtil.getService((ExecutionContext)context, ActionServiceContainer.class);
        ManageableRepository manageableRepository = repositoryService.getCurrentRepository();
        Session session = manageableRepository.getSystemSession(srcWorkspace);
        Node actionableNode = (Node)session.getItem(srcPath);
        if (!actionableNode.isNodeType("exo:actionable")) {
            actionableNode = (Node)session.getItem(nodePath);
        }
        if ((actionNode = actionServiceContainer.getAction(actionableNode, actionName)) == null) {
            actionNode = actionableNode;
        }
        this.fillVariables(actionNode, "exo:publishLocation", context);
        this.fillVariables(actionNode, "exo:pendingLocation", context);
        this.fillVariables(actionNode, "exo:backupLocation", context);
        this.fillVariables(actionNode, "exo:trashLocation", context);
        session.logout();
    }

    private void fillVariables(Node node, String nodeType, ExecutionContext context) throws Exception {
        NodeTypeManager nodeTypeManager = node.getSession().getWorkspace().getNodeTypeManager();
        NodeType publicationable = nodeTypeManager.getNodeType(nodeType);
        for (PropertyDefinition prodef : publicationable.getPropertyDefinitions()) {
            String propName = prodef.getName();
            try {
                String value = node.getProperty(propName).getString();
                context.setVariable(propName, (Object)value);
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)e.getMessage());
            }
        }
    }
}

